  //Includes

#include "mbed.h"
#include "SimpleBLE.h"
#include "LIS3DH.h"
#include "stdlib.h"

//Accelerometer

#define MOSI PC_12
#define MISO PC_11
#define CS PC_5
#define SCLK PC_10

//Bluetooth hc05-6

#define TX D0
#define RX D1

//Init simpleBLE

SimpleBLE ble("ObCP_Roller_Catcher2");


// GPIO set

//Interrupt input

InterruptIn user1(PC_13);  //User1
InterruptIn boutton1(D3);  //Bouton 1 shield
InterruptIn boutton2(D4);  //Bouton 2 shield 
InterruptIn event(A0);     //Passage dans la porte laser 

//Création du Timer

Timer timer;

//Sorties numériques

DigitalOut led1(D14);
DigitalOut transistor(D6);

//PWM output

PwmOut PWMoutput(PB_1);          //Main PWM output
PwmOut Green(PC_8);              //PWM Red LED
PwmOut Red(PC_6);                //PWM Green LED
PwmOut Blue(PC_9);               //PWM Blue LED

//Création des variables

float flag = 0;
bool flag2=false;
int c;
int temps1;
int tref;
char message ;
float end,begin;
int temps2 =0;

//Init accelerometer

LIS3DH      acc(MOSI, MISO, SCLK, CS, LIS3DH_DR_NR_LP_50HZ, LIS3DH_FS_2G);

//Création des liaisons série (pc et bluetooth hc-05)

//Serial pc(USBTX, USBRX);
Serial BT(USBTX,USBRX);

// Characteristics pour affiche sur l'appli Android via BLE

SimpleChar<float> compteur = ble.readOnly_float(0xA000, 0xA003);
SimpleChar<float> Temps = ble.readOnly_float(0xA000, 0xA004);
SimpleChar<float> Temps2 = ble.readOnly_float(0xA000, 0xA007);


void envoi(char message)
{
    BT.printf("%c\n", message);
    //  pc.printf("Message envoye \r\n");
}

void resetUpdate(float rst)
{
    //  pc.printf("reset");
    message = 'R';
    envoi(message);
    timer.reset();
    tref=timer.read_ms();
}

// Changement de mode de course ou changements couleur led

void LEDupdate(uint32_t newColor)
{
    // read individual bytes
    uint8_t* channels = (uint8_t*)&newColor;

    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    Red   = static_cast<float>(channels[0]) / 255.0f;
    Green = static_cast<float>(channels[1]) / 255.0f;
    Blue  = static_cast<float>(channels[2]) / 255.0f;
    flag  = static_cast<float>(channels[3]);
    
    //  pc.printf("%f\n",flag);
    if(flag == 1) {
        //  pc.printf("Mode duo actif");
        message = 'D';
        envoi(message);
        timer.reset();
        flag2=true;
    }else if(flag == 0) {
        //  pc.printf("Mode solo actif   ");
        message = 'S';
        //  pc.printf("%c ",message);
        envoi(message);
        timer.reset();
        flag2=false;
    }
}

void pressed2(){
    led1 = !led1;
    temps2 = timer.read_ms();
    //  pc.printf("Temps calcule, %i \r\n",temps2); 
    
    if(flag2==false){
        Temps=(temps2-temps1)/1000.0f;
        //  pc.printf("Temps1 ; %i", temps1);
        //  pc.printf("Temps de course ; %i", temps2-temps1);
        
    }else{
        //  pc.printf("Temps parcours2 : %i     \n",temps2-tref);
        //  pc.printf("Temps parcours1 : %i     \n", temps1-tref);
        Temps = (temps1-tref)/1000.0f;
        Temps2 = (temps2-tref)/1000.0f;
    }
}



// When characteristic PWM output changing

void PWMupdate(uint8_t pwmvalue)
{

    // cast to float, as PwmOut expects a value between 0.0f and 1.0f
    PWMoutput   = static_cast<float>(pwmvalue) / 255.0f;
}

// When characteristic input changing
void Accupdate()
{

    //accX = float(short((acc.read_reg(LIS3DH_OUT_X_H) << 8) | acc.read_reg(LIS3DH_OUT_X_L))) * 0.001F / 15;
    //accY = float(short((acc.read_reg(LIS3DH_OUT_Y_H) << 8) | acc.read_reg(LIS3DH_OUT_Y_L))) * 0.001F / 15;
    //accZ = float(short((acc.read_reg(LIS3DH_OUT_Z_H) << 8) | acc.read_reg(LIS3DH_OUT_Z_L))) * 0.001F / 15;
    //Temps=15.68;

}

// Characteritic PWM LED RGB
SimpleChar<uint32_t> color = ble.writeOnly_u32(0x6200, 0x6201, &LEDupdate);

// Characteristic PWM output
SimpleChar<uint8_t> pwmout = ble.writeOnly_u8(0xA000, 0xA001, &PWMupdate);

SimpleChar<float> reset = ble.writeOnly_float(0xA000, 0xA005, &resetUpdate);
SimpleChar<float> depart_course = ble.writeOnly_float(0xA000, 0xA006, &resetUpdate);



void skater_d()
{
    if(flag==false) {
        //printf("Ligne de depart coupee solo \n");
        if( flag == false) {
            //printf("Depart skate \n");
            begin = timer.read_ms();
            compteur=100;
            //pc.printf("                                         skater lance %.0f \n", begin);
            flag = true;
        } else if(flag == true) {
            //printf("erreur \n");
            //pc.printf("                                                                      Temps du skater : %.0f \n", end-begin);
            flag = false;
        }
    }
    else if(flag==true) {
        //printf("Ligne d'arrivee coupee \n");
        if( flag == false ) {
            //printf("arrivee coupe sans depart\n");
            flag = true;
        } else if(flag == true ) {
            //printf("Arrivee skate \n");
            end = timer.read_ms();
            //Temps = end-begin;
            compteur=200;
            //wait(1);
            //pc.printf("                                                                      Temps du skater : %.0f \n", end-begin);
            flag = false;
        }
    } 
}

//Main program

void RXevent (){
    //timer.start();
    //c=BT.getc();
    if(BT.readable()){
        BT.scanf("%i", &temps1);
        //wait(1);
    }    
    //  pc.printf(" Message recu :%i \n", temps1);                              // !!!!!!!!!!!!!!!Ca marche pas sans ça !!!!!!!!!!!
    //temps2 = timer.read_ms();
    //Temps= temps2-temps1;
    //pc.printf("Temps calcule, %i \r\n",Temps); 
}    


  

int main(int, char**)
{
    transistor=1;
    ble.start();
    //Ticker t;
    //t.attach(&Accupdate, 15.0f);
    timer.start();
    BT.attach(&RXevent);
    user1.fall(&pressed2);
    //boutton1.fall(&pressed);
    //boutton2.fall(&pressed);
    event.fall(&pressed2);
    //char Buffer[10];
    

    while (1) {
        ble.waitForEvent();
        /*
        pc.printf("%f\n",flag);
        if(flag == 1 && flag2==false){
            pc.printf("Mode duo actif");
        }else if(flag == 0 && flag2==false){
            pc.printf("Mode solo actif   ");
            message = 0;
            pc.printf("%i ",message);
            envoi(message);
            timer.start();
            flag2=true;
        }
        */
        
        //if(BT.readable()){
        //pc.printf("Je recois");
        //BT.attach(&RXevent);
       // c=BT.getc();
        //pc.printf("%i ",c);
        //BT.scanf("%s",&Buffer);
        //pc.printf("%i\n",c);
        
                    //compteur = c;
        //}
        //else {
        //    pc.printf("bof");
        //}
    }
}

//blablabla