/*   Copyright 2016 Rohm Semiconductor

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#include "rohm-sensor-hal/rohm-sensor-hal/rohm_hal.h"       //mbed.h, types, DEBUG_print*
#include "rohm-sensor-hal/rohm-sensor-hal/I2CCommon.h"

#include "rohm-bh1726/rohm-bh1726/bh1726_driver.h"
#include "rohm-bh1726/rohm-bh1726/bh1726.h"
#include "rohm-rpr0521/rohm-rpr0521/rpr0521_driver.h"
#include "rohm-rpr0521/rohm-rpr0521/rpr0521.h"
#include "rohm-bh1745/rohm-bh1745/bh1745_driver.h"
#include "rohm-bh1745/rohm-bh1745/bh1745.h"


Serial pc(USBTX, USBRX);
DigitalOut led1(LED1);
DigitalIn hall_sensor(USER_BUTTON0);
AnalogIn ml8511_input(A0);
AnalogIn bd1020_input(A2);


void bh1726_print_one_value(){
    bool error;
    uint16_t data[2];       //2 channels of 16-bit data

    error = bh1726_read_data(&data[0]);
    if (!error) {
        pc.printf("BH1726 ALS Data0[%4u], Data1[%4u]\n\r", data[0], data[1]);
        }
    else {
        pc.printf("\n\r");
        }
    return;
}


void bd1020_print_one_value(){
    float temperature;

    temperature = -(1000 * (bd1020_input * 3.3f) - 1546) / 8.2;
    pc.printf("BD1020 Temperature=%5.3f\r\n", temperature);
    return;
}


void rpr0521_print_one_value(){
    bool error;
    uint16_t data[3];
    
    error = rpr0521_read_data(&data[0]);
    if (!error) {
        pc.printf("RPR0521 PS[%4u], Als0[%4u], Als1[%4u]\n\r", data[0], data[1], data[2]);
        }
    else {
        pc.printf("\n\r");
        }
}


void bh1745_print_one_value(){
    bool error;
    uint16_t data[4];       //4 channels of 16-bit data

    error = bh1745_read_data(&data[0]);
    if (!error) {
        pc.printf("BH1745 Red[%4u], Green[%4u], Blue[%4u], Clear[%4u]\n\r", data[0], data[1], data[2], data[3]);
        }
    else {
        pc.printf("\n\r");
        }
}


void ml8511_print_one_value(){
    float uvraw, uv;
    #define MIN (0.300)
    #define MAX (0.900)
    #define UVONMAX 15
    uvraw = ml8511_input;
    uv = ( (UVONMAX/(MAX-MIN)) * (uvraw - MIN) );
    pc.printf("ML8511 UV Intensity %2.2fmW/cm^2 (raw[%2.3f])\r\n", uv, uvraw);
}


void bd7411_print_one_value(){
        if (!hall_sensor){
            pc.printf("BD7411 Magnet detected.\n\r");
            }
        else{
            pc.printf("BD7411 No magnet.\n\r");
            }
        led1 = hall_sensor;
}


// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main() {
    pc.printf("\n\r");
    pc.printf("\n\r");
    pc.printf("\n\r");
    pc.printf("6 sensor test on Rohm tileshield with 6 tiles.\r\n");
    pc.printf("\n\r");

    I2CCommonBegin();

    bh1726_wait_until_found();
    pc.printf("BH1726 Sensor found.\n\r");
    bh1726_initial_setup();

    pc.printf("BD1020  Analog sensor assumed to be connected.\n\r");

    rpr0521_wait_until_found();
    pc.printf("RPR0521 Sensor found.\n\r");
    rpr0521_initial_setup();

    bh1745_wait_until_found();
    pc.printf("BH1745 Sensor found.\n\r");
    bh1745_initial_setup();

    pc.printf("ML8511  Analog sensor assumed to be connected.\n\r");
    pc.printf("BD7411 Digital sensor assumed to be connected.\n\r");

    pc.printf("\n\r");
    pc.printf("\n\r");


    while (true) {
        bh1726_print_one_value();
        bd1020_print_one_value();
        rpr0521_print_one_value();
        bh1745_print_one_value();
        ml8511_print_one_value();
        bd7411_print_one_value();
        
        Thread::wait(200);
    }
}

