/*   Copyright 2016 Rohm Semiconductor

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#include "rohm-sensor-hal/rohm-sensor-hal/rohm_hal.h"       //mbed.h, types, DEBUG_print*
#include "rohm-sensor-hal/rohm-sensor-hal/I2CCommon.h"

#include "rohm-rpr0521/rohm-rpr0521/rpr0521_driver.h"
#include "rohm-rpr0521/rohm-rpr0521/rpr0521.h"

Serial pc(USBTX, USBRX);

void rpr0521_print_one_value(){
    bool error;
    uint16_t data[3];
    
    error = rpr0521_read_data(&data[0]);
    if (!error) {
        pc.printf("PS[%4u], Als0[%4u], Als1[%4u]\n\r", data[0], data[1], data[2]);
        }
    else {
        pc.printf("\n\r");
        }
}

void rpr0521_print_raw_values(){
    pc.printf("\nRPR0521 library test program.\n\r");
    I2CCommonBegin();

    rpr0521_wait_until_found();
    pc.printf("\nSensor found.\n\r");
    rpr0521_initial_setup();
    wait(1);
    
    while(1) {
        rpr0521_print_one_value();
        wait(0.1);
    }
}


int main() {
    rpr0521_print_raw_values();
    }

