#include "mbed.h"

Serial pc(USBTX, USBRX);
AnalogIn sensorout(A0);
DigitalOut enablesensor(A1);

void ml8511_print_one_value(){
    float uvraw, uv;
    #define MIN (0.300)
    #define MAX (0.900)
    #define UVONMAX 15
    uvraw = sensorout;
    uv = ( (UVONMAX/(MAX-MIN)) * (uvraw - MIN) );
    pc.printf("UV Intensity %2.2fmW/cm^2 (raw[%2.3f])\r\n", uv, uvraw);
    }

int main() {
    pc.printf("\n\r");
    pc.printf("ML8511 UV sensor test program.\n\r");
    pc.printf("Reported UV intensity values are rough approximates.\n\r");
    pc.printf("Please refer to specification page 4 for UV intensity characteristics.\n\r");
    enablesensor = 1;
    wait_ms(1);
    
    while(1) {
        ml8511_print_one_value();
        wait(0.4);
    }
}
