/*   Copyright 2016 Rohm Semiconductor

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
#ifndef BM1383GLV_H
#define BM1383GLV_H

/* registers */
// [hPa]
#define BM1383GLV_PRESSURE_MIN 0x12C
// [hPa]
#define BM1383GLV_PRESSURE_MAX 0x44C
#define BM1383GLV_REGISTER_DUMP_START 0x10
#define BM1383GLV_ID_REG 0x10
// All control registers are accessible only when POWER is UP and SLEEP is OFF.
#define BM1383GLV_RESET_CONTROL_REG 0x11
#define BM1383GLV_POWER_REG 0x12
#define BM1383GLV_SLEEP_REG 0x13
#define BM1383GLV_MODE_CONTROL_REG 0x14
// MSB of the high threshold value for pressure interrupt generation.
#define BM1383GLV_INT_HIGH_TRESHOLD_MSB 0x15
// LSB of the high threshold value for pressure interrupt generation.
#define BM1383GLV_INT_HIGH_TRESHOLD_LSB 0x16
#define BM1383GLV_INT_LOW_TRESHOLD_MSB 0x17
#define BM1383GLV_INT_LOW_TRESHOLD_LSB 0x18
#define BM1383GLV_INT_CONTROL_REG 0x19
// TEMP_OUT: [15] sign ; [14:5] integer ; [4:0] decimal (2's complement numbers)
#define BM1383GLV_TEMPERATURE_OUT_MSB 0x1A
// Temperature value [C]= TEMP_OUT[15:0]/32
#define BM1383GLV_TEMPERATURE_OUT_LSB 0x1B
// PRESS_OUT[15:5] integer part of pressure value
#define BM1383GLV_PRESSURE_OUT_MSB 0x1C
// PRESS_OUT[4:0] PRESS_OUT_XL[5:0] decimal part of pressure value
#define BM1383GLV_PRESSURE_OUT_LSB 0x1D
// Pressurevalue[hPa] = { PRESS_OUT[15:8] PRESS_OUT[7:0] PRESS_OUT_XL[5:0] } / 2048
#define BM1383GLV_PRESSURE_OUT_DECIMAL 0x1E
#define BM1383GLV_REGISTER_DUMP_END 0x1E
/* registers bits */
#define BM1383GLV_ID_REG_MANUFACTURER_ID (0x03 << 4)
#define BM1383GLV_ID_REG_PART_ID (0x01 << 0)
enum e_BM1383GLV_RESET_CONTROL_REG_SW_RESET {
    BM1383GLV_RESET_CONTROL_REG_SW_RESET_NONE       = (0x00 << 7),
    BM1383GLV_RESET_CONTROL_REG_SW_RESET_EXECUTE    = (0x01 << 7)
    };
enum e_BM1383GLV_RESET_CONTROL_REG_INT_RESET {
    BM1383GLV_RESET_CONTROL_REG_INT_RESET_ACTIVE    = (0x00 << 6),
    BM1383GLV_RESET_CONTROL_REG_INT_RESET_INACTIVE  = (0x01 << 6)               // int terminal high impedance on inactive state
    };
// write 000000
#define BM1383GLV_RESET_CONTROL_REG_RESERVED_WRITE0 (0x00 << 0)
#define BM1383GLV_POWER_REG_RESERVED_WRITE0         (0x00 << 1)
enum e_BM1383GLV_POWER_REG_POWER {
    BM1383GLV_POWER_REG_POWER_DOWN                  = (0x00 << 0),
    BM1383GLV_POWER_REG_POWER_UP                    = (0x01 << 0)
    };
#define BM1383GLV_SLEEP_REG_RESERVED_WRITE0 (0x00 << 1)
enum e_BM1383GLV_SLEEP_REG_SLEEP {
    BM1383GLV_SLEEP_REG_SLEEP_ON                    = (0x00 << 0),
    BM1383GLV_SLEEP_REG_SLEEP_OFF                   = (0x01 << 0)
    };
enum e_BM1383GLV_MODE_CONTROL_REG_AVE_NUM {
    BM1383GLV_MODE_CONTROL_REG_AVE_NUM_SINGLE       = (0x00 << 5),
    BM1383GLV_MODE_CONTROL_REG_AVE_NUM_2_TIMES      = (0x01 << 5),
    BM1383GLV_MODE_CONTROL_REG_AVE_NUM_4_TIMES      = (0x02 << 5),
    BM1383GLV_MODE_CONTROL_REG_AVE_NUM_8_TIMES      = (0x03 << 5),
    BM1383GLV_MODE_CONTROL_REG_AVE_NUM_16_TIMES     = (0x04 << 5),
    BM1383GLV_MODE_CONTROL_REG_AVE_NUM_32_TIMES     = (0x05 << 5),
    BM1383GLV_MODE_CONTROL_REG_AVE_NUM_64_TIMES     = (0x06 << 5)
    };
// write 00
#define BM1383GLV_MODE_CONTROL_REG_RESERVED_WRITE0 (0x00 << 3)
enum e_BM1383GLV_MODE_CONTROL_REG_MODE {
    BM1383GLV_MODE_CONTROL_REG_MODE_STANDBY         = (0x00 << 0),
    BM1383GLV_MODE_CONTROL_REG_MODE_ONE_SHOT        = (0x01 << 0),
    BM1383GLV_MODE_CONTROL_REG_MODE_50MS            = (0x02 << 0),
    BM1383GLV_MODE_CONTROL_REG_MODE_100MS           = (0x03 << 0),
    BM1383GLV_MODE_CONTROL_REG_MODE_200MS           = (0x04 << 0),
    BM1383GLV_MODE_CONTROL_REG_MODE_PROHIBITED5     = (0x05 << 0),
    BM1383GLV_MODE_CONTROL_REG_MODE_PROHIBITED6     = (0x06 << 0),
    BM1383GLV_MODE_CONTROL_REG_MODE_PROHIBITED7     = (0x07 << 0)
    };
enum e_BM1383GLV_INT_CONTROL_REG_TRESHOLD_HIGH {
    BM1383GLV_INT_CONTROL_REG_TRESHOLD_HIGH_IN_LIMITS = (0x00 << 7),
    BM1383GLV_INT_CONTROL_REG_TRESHOLD_HIGH_CROSSED   = (0x01 << 7)
    };
enum e_BM1383GLV_INT_CONTROL_REG_TRESHOLD_LOW {
    BM1383GLV_INT_CONTROL_REG_TRESHOLD_LOW_IN_LIMITS = (0x00 << 6),
    BM1383GLV_INT_CONTROL_REG_TRESHOLD_LOW_CROSSED  = (0x01 << 6)
    };
enum e_BM1383GLV_INT_CONTROL_REG_INT_HIGH {
    BM1383GLV_INT_CONTROL_REG_INT_HIGH_DISABLE      = (0x00 << 5),
    BM1383GLV_INT_CONTROL_REG_INT_HIGH_ENABLE       = (0x01 << 5)
    };
enum e_BM1383GLV_INT_CONTROL_REG_INT_LOW {
    BM1383GLV_INT_CONTROL_REG_INT_LOW_DISABLE       = (0x00 << 4),
    BM1383GLV_INT_CONTROL_REG_INT_LOW_ENABLE        = (0x01 << 4)
    };
enum e_BM1383GLV_INT_CONTROL_REG_INT_PULLUP {
    BM1383GLV_INT_CONTROL_REG_INT_PULLUP_ENABLE     = (0x00 << 3),              // pull up resistor in INT terminals
    BM1383GLV_INT_CONTROL_REG_INT_PULLUP_DISABLE    = (0x01 << 3)               // no pull up resistor in INT terminals
    };
#define BM1383GLV_INT_CONTROL_REG_RESERVED_RES      (0x00 << 2)
enum e_BM1383GLV_INT_CONTROL_REG_INTERRUPT_STATE {
    BM1383GLV_INT_CONTROL_REG_INTERRUPT_STATE_KEEP_UNTIL_CLEARED = (0x00 << 1), // terminal is latched until interrupt is cleared
    BM1383GLV_INT_CONTROL_REG_INTERRUPT_STATE_CONTINUOUS_UPDATE = (0x01 << 1)   // terminal is updated after each measurement
    };
enum e_BM1383GLV_INT_CONTROL_REG_INTERRUPT {
    BM1383GLV_INT_CONTROL_REG_INTERRUPT_DISABLE     = (0x00 << 0),
    BM1383GLV_INT_CONTROL_REG_INTERRUPT_ENABLE      = (0x01 << 0)
    };
 /*registers bit masks */
#define BM1383GLV_ID_REG_MANUFACTURER_MASK 0xF0
#define BM1383GLV_ID_REG_PART_MASK 0x0F
#define BM1383GLV_RESET_CONTROL_REG_SW_RESET_MASK 0x80
#define BM1383GLV_RESET_CONTROL_REG_INT_RESET_MASK 0x40

#define BM1383GLV_RESET_CONTROL_REG_RESERVED_MASK 0x3F

#define BM1383GLV_POWER_REG_RESERVED_MASK 0xFE
#define BM1383GLV_POWER_REG_POWER_MASK 0x01
#define BM1383GLV_SLEEP_REG_RESERVED_MASK 0xFE
#define BM1383GLV_SLEEP_REG_SLEEP_MASK 0x01
#define BM1383GLV_MODE_CONTROL_REG_AVE_NUM_MASK 0xE0
#define BM1383GLV_MODE_CONTROL_REG_RESERVED_MASK 0x18

#define BM1383GLV_MODE_CONTROL_REG_MODE_MASK 0x07
#define BM1383GLV_INT_HIGH_TRESHOLD_MSB_ALLBITS_MASK 0xFF
#define BM1383GLV_INT_HIGH_TRESHOLD_LSB_ALLBITS_MASK 0xFF
#define BM1383GLV_INT_LOW_TRESHOLD_MSB_ALLBITS_MASK 0xFF
#define BM1383GLV_INT_LOW_TRESHOLD_LSB_ALLBITS_MASK 0xFF
#define BM1383GLV_INT_CONTROL_REG_TRESHOLD_HIGH_MASK 0x80
#define BM1383GLV_INT_CONTROL_REG_TRESHOLD_LOW_MASK 0x40
#define BM1383GLV_INT_CONTROL_REG_INT_HIGH_MASK 0x20
#define BM1383GLV_INT_CONTROL_REG_INT_LOW_MASK 0x10
#define BM1383GLV_INT_CONTROL_REG_INT_PULLUP_MASK 0x08

#define BM1383GLV_INT_CONTROL_REG_RESERVED_MASK 0x04
#define BM1383GLV_INT_CONTROL_REG_INTERRUPT_STATE_MASK 0x02

#define BM1383GLV_INT_CONTROL_REG_INTERRUPT_MASK 0x01
#define BM1383GLV_TEMPERATURE_OUT_MSB_ALLBITS_MASK 0xFF
#define BM1383GLV_TEMPERATURE_OUT_LSB_ALLBITS_MASK 0xFF
#define BM1383GLV_PRESSURE_OUT_MSB_ALLBITS_MASK 0xFF
#define BM1383GLV_PRESSURE_OUT_LSB_ALLBITS_MASK 0xFF
#define BM1383GLV_PRESSURE_OUT_DECIMAL_ALLBITS_MASK 0x3F

#endif /* BM1383GLV_H */
