/*
The MIT License (MIT)
Copyright (c) 2017 Rohm Semiconductor

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
*/

#include "RegisterWriter/RegisterWriter/rohm_hal2.h"

#include "rohm-bh1790glc-driver/bh1790glc_registers.h"
#include "rohm-bh1790glc-driver/bh1790glc.h"

DigitalOut led1(LED1);
Serial pc(USBTX, USBRX);

I2C i2c(I2C_SDA, I2C_SCL);
RegisterWriter i2c_rw(i2c);
BH1790GLC bh1790glc(i2c_rw);

/* Global variables for timer */
bool interval_elapsed;
Ticker ticker;

void timer_isr()
{
    interval_elapsed = true;
}

int main()
{
    uint16_t data[2];
    int error;

    pc.baud(115200);
    i2c.frequency(400000);

    wait(0.1);

    do{ //until init OK.
        error = bh1790glc.set_default_on();
        Thread::wait(50);
        led1 = !led1;   //Red led toggle
        Thread::wait(200);
        }
    while (error);
    led1 = 0; //Red off

    interval_elapsed = false;
    ticker.attach(&timer_isr, 0.03125);                 //32Hz

    while(true) {
        if (interval_elapsed) {                         //Wait until ISR
            error = bh1790glc.getresults(data);
            if (!error) {
                int i;
                pc.printf("%d, \t%d", data[1], data[0]);
                for (i=0; i < (data[1]/200); i++) {
                    pc.printf(" ");
                    }
                pc.printf("I\r\n");
            }
            interval_elapsed = false;
        }
    }
} /* main() */

