/*   Copyright 2016 Rohm Semiconductor

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
#include "../../rohm-sensor-hal/rohm-sensor-hal/rohm_hal.h"         //types, DEBUG_print*
#include "../../rohm-sensor-hal/rohm-sensor-hal/I2CCommon.h"        //read_register, write_register, change_bits

#include "../rohm-bh1745/bh1745.h"      //bh1745_* register definitions
#include "../rohm-bh1745/bh1745_driver.h"
//Choose SAD according to setup
//#define SAD  0x38
#define SAD 0x39

/* bh1745 driver*/
uint8_t bh1745_readId(){
    uint8_t id;
    uint8_t read_bytes;

    read_bytes = read_register(SAD, BH1745_ID_REG, &id, 1);
    if ( read_bytes > 0 ){
        uint8_t partid;
        
        DEBUG_printf("Manufacturer: %u\n\r", id);
        if (id == 0xe0){
            read_bytes = read_register(SAD, BH1745_SYSTEM_CONTROL, &partid, 1);
            partid = partid & 0b00111111;
            if ( read_bytes > 0 ){
                DEBUG_printf("Part ID: %u\n\r", partid);
                if (partid == 0x0b){//OK
                    return(partid);
                } else {
                    DEBUG_print("Wrong part ID for this driver.\n\r");
                    return 255;
                }
            } else {
                DEBUG_print("Part ID read failed.\n\r");
                return 255;
            }
        } else {
            DEBUG_print("Wrong manufacturer Id for this driver.\n\r");
            return 255;
        }
    } else {
        DEBUG_print("Manufacturer read failed.\n\r");
        return 255;
    }
}

void bh1745_wait_until_found(){
    uint8_t id;

    id = bh1745_readId();
    while (id == 255){
        wait(100);
        id = bh1745_readId();
    }
    return;
}

void bh1745_soft_reset(){
    change_bits(SAD, BH1745_MODE_CONTROL1, BH1745_SYSTEM_CONTROL_SW_RESET_MASK, BH1745_SYSTEM_CONTROL_SW_RESET_START);
}

void bh1745_clear_interrupt(){
    uint8_t tmp;
    read_register(SAD, BH1745_INTERRUPT, &tmp, 1);
}

void bh1745_initial_setup(){
    write_register(SAD, BH1745_INTERRUPT,
        (BH1745_INTERRUPT_STATUS_INACTIVE |
        BH1745_INTERRUPT_LATCH_ENABLE |
        BH1745_INTERRUPT_PIN_DISABLE)
        );
    write_register(SAD, BH1745_PERSISTENCE,
        (BH1745_PERSISTENCE_OF_INTERRUPT_STATUS_TOGGLE_AFTER_MEASUREMENT)
        );
    write_register(SAD, BH1745_MODE_CONTROL1,
        (BH1745_MODE_CONTROL1_MEASUREMENT_TIME_160MSEC)
        );
    write_register(SAD, BH1745_MODE_CONTROL2,
        (BH1745_MODE_CONTROL2_RGBC_MEASUREMENT_ACTIVE |
         BH1745_MODE_CONTROL2_ADC_GAIN_1X)
        );
}

/* input param: data16, pointer to 4*16bit memory 
   return: error, true/false */
bool bh1745_read_data(uint16_t* data16){
    #define BH1745_DATA_LEN 8
    uint8_t data[BH1745_DATA_LEN];
    uint8_t read_bytes;

    read_bytes = read_register(SAD, BH1745_RED_DATA_LSBS, &data[0], BH1745_DATA_LEN);
    if (read_bytes == BH1745_DATA_LEN){
        data16[0] = (data[0]) | (data[1] << 8); //red
        data16[1] = (data[2]) | (data[3] << 8); //green
        data16[2] = (data[4]) | (data[5] << 8); //blue
        data16[3] = (data[6]) | (data[7] << 8); //clear
        return false;
    } else {
        DEBUG_printf("Read error. Read %d bytes\n\r", read_bytes);
        return true;
    }
   
}
