/*   Copyright 2016 Rohm Semiconductor

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
#include "../../rohm-sensor-hal/rohm-sensor-hal/rohm_hal.h"         //types, DEBUG_print*
#include "../../rohm-sensor-hal/rohm-sensor-hal/I2CCommon.h"        //read_register, write_register, change_bits

#include "../rohm-bh1726/bh1726.h"      //bh1726_* register definitions
#include "../rohm-bh1726/bh1726_driver.h"
//Choose SAD according to setup
#define SAD  0x29
//#define SAD 0x39

/* bh1726 driver*/
uint8_t bh1726_readId(){
    uint8_t partid;
    uint8_t read_bytes;

    read_bytes = read_register(SAD, BH1726_ID, &partid, 1);
    if ( read_bytes > 0 ){
        DEBUG_printf("Part ID: %u\n\r", partid);
        return(partid);
        }
    else{
        DEBUG_print("Part ID read failed.\n\r");
        return 255;
        }
}

void bh1726_dumpregs(uint8_t dumpstart, uint8_t dumpend){
    uint8_t i;
    uint8_t value;
    uint8_t read_bytes;
    
    for(i = dumpstart;i < dumpend;i++){
        read_bytes = read_register(SAD, i, &value, 1);
        if ( read_bytes > 0 ){
            DEBUG_printf("Register [%3u]=[%3u]\n\r", i, value);
            }
        }
    return;
}

void bh1726_wait_until_found(){
  uint8_t id;

  DEBUG_printf("Hoping to find part ID: %u\n\r", BH1726_ID_NUMBER_FOR_PART);
  id = bh1726_readId();
  while (id != BH1726_ID_NUMBER_FOR_PART){
    wait_ms(100);
    id = bh1726_readId();
    }
  return;
  }

void bh1726_soft_reset(){
    write_register(SAD, BH1726_SOFTWARE_RESET, 0);
}

void bh1726_clear_interrupt(){
    write_register(SAD, BH1726_INTERRUPT_OUTPUT_RESET, 0);
}

void bh1726_initial_setup(){
    write_register(SAD, BH1726_TIMING,
        (BH1726_TIMING_ITIME_38CYCLE)   //105ms measurement time
        );
    write_register(SAD, BH1726_INTERRUPT,
        (BH1726_INTERRUPT_INT_LATCH_YES |
        BH1726_INTERRUPT_INT_EN_FALSE |
        BH1726_INTERRUPT_PERSIST_DRDY)
        );
    write_register(SAD, BH1726_GAIN,
        (BH1726_GAIN_GAIN0_X1 |
         BH1726_GAIN_GAIN1_X1)
        );
    write_register(SAD, BH1726_WAIT,
        (BH1726_WAIT_WAIT_NO)
        );
    write_register(SAD, BH1726_CONTROL,
        (BH1726_CONTROL_ADC_EN_TRUE |
        BH1726_CONTROL_POWER_ON)
        );
}

/* input param: data16, pointer to 4*16bit memory 
   return: error, true/false */
bool bh1726_read_data(uint16_t* data16){
    #define BH1726_DATA_LEN 4
    uint8_t data[BH1726_DATA_LEN];
    uint8_t read_bytes;

    read_bytes = read_register(SAD, BH1726_DATA0_LSBS, &data[0], BH1726_DATA_LEN);
    if (read_bytes == BH1726_DATA_LEN){
        data16[0] = (data[0]) | (data[1] << 8); //data0
        data16[1] = (data[2]) | (data[3] << 8); //data1
        return false;
        }
    else{
        DEBUG_printf("Read error. Read %d bytes\n\r", read_bytes);
        return true;
        }
   
    }
