/*   Copyright 2016 Rohm Semiconductor

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/

#include "rohm-sensor-hal/rohm-sensor-hal/rohm_hal.h"       //mbed.h, types, DEBUG_print*
#include "rohm-sensor-hal/rohm-sensor-hal/I2CCommon.h"

#include "rohm-bh1726/rohm-bh1726/bh1726_driver.h"
#include "rohm-bh1726/rohm-bh1726/bh1726.h"

Serial pc(USBTX, USBRX);

void bh1726_print_one_value(){
    bool error;
    uint16_t data[2];       //2 channels of 16-bit data

    error = bh1726_read_data(&data[0]);
    if (!error) {
        pc.printf("ALS Data0[%4u], Data1[%4u]\n\r", data[0], data[1]);
        }
    else {
        pc.printf("\n\r");
        }
}

void bh1726_print_raw_values(){
    pc.printf("\nbh1726 library test program.\n\r");
    I2CCommonBegin();

    bh1726_wait_until_found();
    bh1726_initial_setup();
    wait(1);
//    bh1726_dumpregs(BH1726_REGISTER_DUMP_START, BH1726_REGISTER_DUMP_END);
    
    while(1) {
        bh1726_print_one_value();
        wait(0.2);
    }
}


int main() {
    bh1726_print_raw_values();
    }

