/*   Copyright 2016 Rohm Semiconductor

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
#ifndef i2c_common_pp_h
#define i2c_common_pp_h

#include "rohm_hal2.h"       //types, DEBUG_print*, USE_*_HARDWARE_I2C

class RegisterWriter
{
public:
    /**
    * Use pre-instantiated I2C instance for hal.
    *
    * @param i2c_obj pre-instantiated i2c object.
    */
    RegisterWriter(I2C &i2c_obj);

    /**
    * Create a i2c instance which is connected to specified I2C pins.
    *
    * @param sda SDA pin
    * @param sdl SCL pin
    */
    RegisterWriter(PinName sda = I2C_SDA, PinName scl = I2C_SCL);

    /**
    * RegisterWriter destructor
    */
    ~RegisterWriter();

    /**
    * read/write commands for sensor registers
    */
    uint8_t read_register(uint8_t sad, uint8_t reg, uint8_t* buf, uint8_t buf_len);
    uint8_t read_fifo_register(uint8_t sad, uint8_t reg, uint8_t* buf, uint8_t buf_len);
    void write_register(uint8_t sad, uint8_t reg, uint8_t* data, uint8_t data_len);
    void write_register(uint8_t sad, uint8_t reg, uint8_t data);
    bool change_bits(uint8_t sad, uint8_t reg, uint8_t mask, uint8_t bits);

private:
    I2C i2c_bus;
    bool self_created_i2c;
};




#endif


