/*   Copyright 2016 Rohm Semiconductor

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
*/
#include "../RegisterWriter/rohm_hal2.h"           //types, USE_MBED_HARDWARE_I2C, DEBUG_print*, I2C.h, I2C_SDA, I2C_SCL

#ifdef USE_MBED_HARDWARE_I2C
#include "../RegisterWriter/RegisterWriter.h"          //prototypes
#define I2C_WRITE 0
#define I2C_READ  1


RegisterWriter::RegisterWriter(I2C &i2c_obj) : i2c_bus(i2c_obj) {
    self_created_i2c = false;
}

RegisterWriter::RegisterWriter(PinName sda, PinName scl) : i2c_bus(sda, scl) {
    self_created_i2c = true;
}

RegisterWriter::~RegisterWriter(){
    if (self_created_i2c == true){
        delete &i2c_bus;
        }
}

/* i2c common functions */
uint8_t RegisterWriter::read_register(uint8_t sad, uint8_t reg, uint8_t* buf, uint8_t buf_len) {
    uint8_t received_bytes;
    int read_ok;

    i2c_bus.write( (int)((sad << 1) | I2C_WRITE), (char*)&reg, (int)1 );
    read_ok = i2c_bus.read( (int)((sad << 1) | I2C_READ), (char*)buf, (int)buf_len);

    if( read_ok == 0 ){     //0 == success(ack)
        received_bytes = buf_len;
        }
    else{                   //non0 == fail (nack)
        received_bytes = 0;
        }
    return( received_bytes );
}

uint8_t RegisterWriter::read_fifo_register(uint8_t sad, uint8_t reg, uint8_t* buf, uint8_t buf_len) {
    uint8_t received_bytes;
    int read_ok;

    i2c_bus.write( (int)((sad << 1) | I2C_WRITE), (char*)&reg, (int)1, true );
    read_ok = i2c_bus.read( (int)((sad << 1) | I2C_READ), (char*)buf, (int)buf_len);

    if( read_ok == 0 ){     //0 == success(ack)
        received_bytes = buf_len;
        }
    else{                   //non0 == fail (nack)
        received_bytes = 0;
        }
    return( received_bytes );
}

uint8_t RegisterWriter::hs_read_register(uint8_t sad, uint8_t reg, uint8_t* buf, uint8_t buf_len) {
    set_hs_mode_for_one_command();
    //Next read command as usual, but in highspeed
    return read_fifo_register(sad, reg, buf, buf_len);
}

bool RegisterWriter::write_register(uint8_t sad, uint8_t reg, uint8_t* data, uint8_t data_len) {
    bool error;
    error = i2c_bus.write( (int)((sad << 1) | I2C_WRITE ), (char*)&reg, (int)1, true);
    error = error || i2c_bus.write( (int)((sad << 1) | I2C_WRITE ), (char*)data, (int)data_len, false);
    return error;
}

bool RegisterWriter::write_register(uint8_t sad, uint8_t reg, uint8_t data) {
    char data_to_send[2];
    bool error;

    data_to_send[0] = reg;
    data_to_send[1] = data;
    error = i2c_bus.write( (int)((sad << 1) | I2C_WRITE ), &data_to_send[0], 2);

    return error;
}

bool RegisterWriter::change_bits(uint8_t sad, uint8_t reg, uint8_t mask, uint8_t bits){
    uint8_t value, read_bytes;
    bool error;
    read_bytes = read_register(sad, reg, &value, 1);
    if( read_bytes != 0 ){
        value = value & ~mask;
        value = value | (bits & mask);
        return write_register(sad, reg, value);
        }
    else{
        //DEBUG_printf("Read before change_bits() failed.");
        return true;
        }
}

void RegisterWriter::set_hs_mode_for_one_command(){
    #define MCODE (1<<3)
    char temp;
    //Fullspeed mode -> highspeed mode for one command.
    i2c_bus.write( (int)(MCODE), (char*)&temp, (int)0, true ); //Trick to write just mcode+make nack.
    }


#endif


