/*

Test program to use Rohm sensors with Lazurite Graph application 
http://www.lapis-semi.com/lazurite-jp/contents/LazuriteGraph/LazuriteGraph.html

*/

#include "mbed.h"
#include "KX022.h"
#include "BM1383GLV.h"

Serial pc(USBTX, USBRX);
KX022 acc(I2C_SDA, I2C_SCL);
BM1383GLV sensor(I2C_SDA, I2C_SCL);

int main() {
    pc.baud(115200);
    
    while(1) {
        pc.printf("STX,");
        pc.printf("%.2f,", acc.getAccX());
        pc.printf("%.2f,", acc.getAccY());
        pc.printf("%.2f,", acc.getAccZ());
        pc.printf("%.2f,", sensor.getPressure());
        pc.printf("%.2f", sensor.getTemperature());
        pc.printf(",ETX\n");
        wait(0.1);
    }
}
