/* LWIPBP3595Interface.h */
/* Copyright (C) 2016 Grape Systems, Inc. */
/* The base file is LWIPInterface.h. */

/* LWIPInterface.h */
/* LWIP implementation of NetworkInterfaceAPI
 * Copyright (c) 2015 ARM Limited
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef LWIP_BP3595_INTERFACE_H
#define LWIP_BP3595_INTERFACE_H

#include "LWIPInterface.h"
#include "WiFiInterface.h"


/** LWIPBP3595Interface class
 *  Implementation of the NetworkInterface for LWIP
 */
class LWIPBP3595Interface : public LWIPInterface
{
public:

    /** Start the interface
     *  @param ssid Name of the network to connect to
     *  @param pass Security passphrase to connect to the network
     *  @param security Type of encryption to connect with
     *  @return 0 on success
     */
    virtual int connect(
        const char *ssid,
        const char *pass,
        nsapi_security_t security = NSAPI_SECURITY_WPA2);

    virtual int disconnect();

    /** Get the internally stored IP address
     *  @return             IP address of the interface or null if not yet connected
     */
    virtual const char *get_ip_address();
 
    /** Get the internally stored MAC address
     *  @return             MAC address of the interface
     */
    virtual const char *get_mac_address();

private:
    // Implementation of EthernetInterface
    virtual int connect() {return 0;}

};


#endif
