/*****************************************************************************
  KX224_I2C.h

 Copyright (c) 2017 ROHM Co.,Ltd.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
*
*  KX224-1053 3 axis accelerometer library
*
*  @modified by Ren Boting
*  @version 1.0
*  @date    18-February-2019
*
*  Library for "KX224-1053 3 axis accelerometer library"
*    https://www.rohm.co.jp/sensor-shield-support/accelerometer
*
*/
#ifndef _KX224_H_
#define _KX224_H_

#include "mbed.h"

#define KX224_DEVICE_ADDRESS_1E   (0x1E << 1)    // 7bit Addrss
#define KX224_DEVICE_ADDRESS_1F   (0x1F << 1)    // 7bit Address
#define KX224_WAI_VAL             (0x2B)

#define KX224_XOUT_L              (0x06)
#define KX224_WHO_AM_I            (0x0F)
#define KX224_CNTL1               (0x18)
#define KX224_ODCNTL              (0x1B)

#define KX224_CNTL1_TPE           (1 << 0)
#define KX224_CNTL1_WUFE          (1 << 1)
#define KX224_CNTL1_TDTE          (1 << 2)
#define KX224_CNTL1_GSELMASK      (0x18)
#define KX224_CNTL1_GSEL_8G       (0x00)
#define KX224_CNTL1_GSEL_16G      (0x08)
#define KX224_CNTL1_GSEL_32G      (0x10)
#define KX224_CNTL1_DRDYE         (1 << 5)
#define KX224_CNTL1_RES           (1 << 6)
#define KX224_CNTL1_PC1           (1 << 7)

#define KX224_ODCNTL_OSA_50HZ     (2)
#define KX224_ODCNTL_LPRO         (1 << 6)
#define KX224_IIR_BYPASS          (1 << 7)

#define KX224_CNTL1_VAL           (KX224_CNTL1_RES | KX224_CNTL1_GSEL_8G)
#define KX224_ODCNTL_VAL          (KX224_ODCNTL_OSA_50HZ)

#ifdef _DEBUG
#undef DEBUG_PRINT
#define DEBUG_PRINT(...) printf(__VA_ARGS__)
#else
#define DEBUG_PRINT(...)
#endif

class KX224
{
public:
    /**
    * KX224 constructor
    *
    * @param sda SDA pin
    * @param sdl SCL pin
    * @param addr slave address of the I2C peripheral (default: 0x1E)
    */
	KX224(PinName sda, PinName scl, int slave_addr = KX224_DEVICE_ADDRESS_1E);
    /**
    * KX224 destructor
    */
    ~KX224();
    uint8_t initialize(void);
    void get_val(float *data);
private:
    I2C m_i2c;
    int m_addr;
    uint16_t _g_sens;
    void write(uint8_t memory_address, char *data);
    void read(uint8_t memory_address, char *data, int size);
};

#endif // _KX224_H_
