/*****************************************************************************
  BH1749NUC.h

 Copyright (c) 2018 ROHM Co.,Ltd.

 Permission is hereby granted, free of charge, to any person obtaining a copy
 of this software and associated documentation files (the "Software"), to deal
 in the Software without restriction, including without limitation the rights
 to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 copies of the Software, and to permit persons to whom the Software is
 furnished to do so, subject to the following conditions:

 The above copyright notice and this permission notice shall be included in
 all copies or substantial portions of the Software.

 THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 THE SOFTWARE.
******************************************************************************/
#ifndef _BH1749NUC_H_
#define _BH1749NUC_H_

#include "mbed.h"

#ifdef _DEBUG
#undef DEBUG_PRINT
#define DEBUG_PRINT(...) printf(__VA_ARGS__)
#else
#define DEBUG_PRINT(...)
#endif

#define BH1749NUC_DEVICE_ADDRESS_38             (0x38 << 1) // 7bit Addrss
#define BH1749NUC_DEVICE_ADDRESS_39             (0x39 << 1) // 7bit Addrss
#define BH1749NUC_PART_ID_VAL                   (0x0D)
#define BH1749NUC_MANUFACT_ID_VAL               (0xE0)

#define BH1749NUC_SYSTEM_CONTROL                (0x40)
#define BH1749NUC_MODE_CONTROL1                 (0x41)
#define BH1749NUC_MODE_CONTROL2                 (0x42)
#define BH1749NUC_RED_DATA_LSB                  (0x50)
#define BH1749NUC_MANUFACTURER_ID               (0x92)

#define BH1749NUC_MODE_CONTROL1_MEAS_MODE_120MS (2)
#define BH1749NUC_MODE_CONTROL1_MEAS_MODE_240MS (3)
#define BH1749NUC_MODE_CONTROL1_RGB_GAIN_X1     (1 << 3)
#define BH1749NUC_MODE_CONTROL1_RGB_GAIN_X32    (3 << 3)
#define BH1749NUC_MODE_CONTROL1_IR_GAIN_X1      (1 << 5)
#define BH1749NUC_MODE_CONTROL1_IR_GAIN_X32     (3 << 5)
#define BH1749NUC_MODE_CONTROL2_RGB_EN          (1 << 4)

#define BH1749NUC_MODE_CONTROL1_VAL             (BH1749NUC_MODE_CONTROL1_MEAS_MODE_120MS | BH1749NUC_MODE_CONTROL1_RGB_GAIN_X1 | BH1749NUC_MODE_CONTROL1_IR_GAIN_X1)
#define BH1749NUC_MODE_CONTROL2_VAL             (BH1749NUC_MODE_CONTROL2_RGB_EN)

#define GET_BYTE_RED_TO_GREEN2 (12)
#define WAIT_TMT2_MAX          (340)

/**  Interface for controlling BME280 Combined humidity and pressure sensor
 *
 * @code
 * #include "mbed.h"
 * #include "BH1749NUC.h"
 * 
 * BH1749NUC color(I2C_SDA, I2C_SCL);
 * 
 * int main(void) {
 *     uint16_t buf[5];
 *     color.init();
 *  
 *     while (1) {
 *         color.get_val(buf);
 *         printf("BH1749 color : [R] %04x, [G] %04x, [B] %04x, [IR] %04x, [G2] %04x\n", buf[0], buf[1], buf[2], buf[3], buf[4]);
 *         wait(1);
 *     }
 * }
 * @endcode
 */

/** BH1749NUC class
 *
 *  BH1749NUC: A library to correct color data using Rohm BH1749NUC color sensor device
 *
 */ 
class BH1749NUC
{
public:
    /** Create a BH1749NUC instance
    *   which is connected to specified I2C pins with specified address
    *
    * @param sda I2C-bus SDA pin
    * @param sdl I2C-bus SCL pin
    * @param addr slave address of the I2C peripheral (default: 0x72)
    */
    BH1749NUC(PinName sda, PinName scl, int addr = BH1749NUC_DEVICE_ADDRESS_39);
    /**
    * BH1749NUC destructor
    */
    ~BH1749NUC();
    /**
    * Initialize BH1749NUC device
    */
    int init(void) ;
    /**
    * Get color sensor raw value
    * @param data buffer to store raw data
    */
    int get_rawval(char *data);
    /**
    * Get color sensor value
    * @param data buffer to store sensor data (R, B, G, IR and G2)
    */
    int get_val(unsigned short *data);
private:
    int write(char memory_address, char *data, int size);
    int read(char memory_address, char *data, int size);
    I2C m_i2c;
    int m_addr;
};

#endif // _BH1749NUC_H_
