#include "mbed.h"

Serial pc(USBTX, USBRX);
AnalogIn sensor(A2);

int main() {
    float temperature1;
    float temperature2;
    pc.printf("\n\r");
    pc.printf("BD1020HFV Temperature sensor test program.\n\r");
    pc.printf("All values are approximates based on specification graph.\n\r");
    pc.printf("Formula values should be calibrated before use.\n\r");
    while(1) {
        //Input voltage 0-3.3V == 0.0-1.0f
        //-40'C == 1.87V
        //  0'C == 1.546V
        //192'C == 0V (out of scale)
        //1.87V / 232'C = 0.008060V/'C
        
        temperature1 = -(1000 * (sensor * 3.3f) - 1546) / 8.2;
        temperature2 = 192 - ( sensor * 3.3f / 0.008060 );
        pc.printf("Temperature, formula1=%5.3f, formula2=%5.3f\r\n", temperature1, temperature2);
        wait(1);
    }
}
