#include "mbed.h"

//ANNOTATIONS
//
//accelerometer: LSM6DS0
//
//  SDO/SA0 pin is connected to voltage supply -> device address is 1101011
//
//  CTRL_REG8:
//      IF_ADD_INC  default value: 1 -> Register address automatically increased
//                                  during a multiple byte access with a serial
//                                  interface (I2C)  
//      BLE         default value: 0 -> Big Endian (LSB @ lower address)
//

#define ACC_ADD_W       0b11010110 
#define ACC_ADD_R       0b11010111
#define X_OUT_1         0x28
#define X_OUT_2         0x29    
#define Y_OUT_1         0x2A
#define Y_OUT_2         0x2B
#define Z_OUT_1         0X2C
#define Z_OUT_2         0X2D
#define CTRL_REG6_XL    0x20
#define WHO_AM_I        0x0F
#define REFERENCE_G     0x0B


I2C myi2c(D14, D15); 
Serial pc (SERIAL_TX, SERIAL_RX);

//void testRead(); void testWrite();

int read_reg(int reg_add);

void setup(void);

int merge_int(int val_msb, int val_lsb);

void write_reg(int reg_add, int data_in);



int main ()
{   
    setup();
    //testRead(); testWrite();
    int out[2];
    
    while(true)
    {
        //testWrite();
        out[1]=read_reg(X_OUT_1);
        out[0]=read_reg(X_OUT_2);
        pc.printf("X: %d \n\r", merge_int(out[0], out[1])); 
        out[1]=read_reg(Y_OUT_1);
        out[0]=read_reg(Y_OUT_2);
        pc.printf("Y: %d%d \n\r ", out[1], out[0]);
        out[1]=read_reg(Z_OUT_1);
        out[0]=read_reg(Z_OUT_2);
        pc.printf("Z: %d%d \n\r", out[1], out[0]);
        wait(1.0);
    }    
}



int read_reg(int reg_add)
{   
    int status=0;
    char dato;
    myi2c.start(); //viene mandato il segnale di start
    status=myi2c.write(ACC_ADD_W); //scrivo l'indirizzo dell'accelerometro in scrittura  
    if (status==0)
        pc.printf("ERRORE1");
    status=myi2c.write(reg_add); //mando indirizzo del registro
    if (status==0)
        pc.printf("ERRORE2");
    myi2c.start(); //mando il segnale di restart
    status=myi2c.write(ACC_ADD_R); //mando indirizzo dell'accelerometro in lettura
    if (status==0)
        pc.printf("ERRORE3");
    dato=myi2c.read(0); //leggo il dato sul bus e lo salvo in dato
    myi2c.stop(); //mando il segnale di stop
    return dato; //ritorno il dato
}



void setup(void)
{
    pc.printf("Starting up the machine...\n\r");
    write_reg(CTRL_REG6_XL, 0x20);
    return;
}



int merge_int(int val_msb, int val_lsb)
{
    int to_return = val_lsb + val_msb<<8;
    return to_return;
}



/*void testRead()
{
    int out[2];
    out[1]=read_reg(WHO_AM_I);
    pc.printf("WHO_AM_I: %d \n\r", out[1]);
}*/



void write_reg(int reg_add, int data_in)
{
    int status=0;
    myi2c.start(); //viene mandato il segnale di start
    status=myi2c.write(ACC_ADD_W); //scrivo l'indirizzo dell'accelerometro in scrittura  
    if (status==0)
        pc.printf("ERRORE1");
    status=myi2c.write(reg_add); //mando indirizzo del registro
    if (status==0)
        pc.printf("ERRORE2");
    status=myi2c.write(data_in); 
    if (status==0)
        pc.printf("ERRORE3");
    myi2c.stop(); //mando il segnale di stop
    return;
}



/*void testWrite()
{
        
    int dato;
    write_reg(REFERENCE_G,89);
    dato=read_reg(REFERENCE_G);
    pc.printf("vediamo se funziona: %d", dato); 
    return ; //ritorno il dato

}*/