#include "mbed.h"
#include "AQM0802.h"
#include "mpu6050.h"

Serial pc(USBTX, USBRX);
MPU6050 mpu(D4, D5);
AQM0802 lcd(D4,D5);

int main()
{
    double gx,gy,gz;    //Z角速度情報を格納
    int i_gz;           //Ｚ軸データint型変換格納
    char str[5];        //LCD表示用文字列
    
    
    pc.baud(9600);      //通信速度は9600bps
    mpu.setMaxScale(MAX_ACC_8G, MAX_GYRO_1000degpersec);//[1000deg/sec]を測定上限とする。
    lcd.init();         //LCD初期化
    lcd.locate(1,0);    //桁、行
    lcd.print("GYRO_Z");//1行目に「GYRO_Z」を表示
    
    while(true) {     
        wait(0.2);
        //★☆角速度情報の取得☆★
        mpu.readGyroscope(gx, gy, gz);//関数仕様上３軸すべて角速度取得する。
        i_gz=(int)gz;   //doubleは大きすぎるのでint型へ変換
        
        //★☆ターミナルへの角速度表示☆★
        pc.printf("gz:%d\r\n", i_gz);//Z軸方向のみ表示する。（他は使わない）
        
        //★☆LCDへの角速度表示☆★        
        lcd.locate(1,1);//桁、行
        lcd.print("     ");//表示クリア
        sprintf(str,"%4d",i_gz);
        lcd.locate(1,1);//桁、行
        lcd.print(str); //表示クリア
    }
}
