 //エンコーダの動作確認。
 //左右モータの回転数を検出するプログラム
 #include "mbed.h"
 #include "CRotaryEncoder.h"
 
 #define    PULSE_TO_UM     10  //エンコーダ1パルス当たりのタイヤ移動距離[um]
                                //実測で値を調整する。
 
  
 Serial PC(USBTX,USBRX);
 CRotaryEncoder encoder_a(D1,D0);       //モータAのエンコーダ
 CRotaryEncoder encoder_b(D11,D12);     //モータBのエンコーダ
  
 
 int main(){
    int enc_count_a=0,enc_count_b=0;    //エンコーダパルス数を格納
    int distance_a=0,distance_b=0;      //タイヤ移動距離を格納[mm]
     while(1)
    {
         enc_count_a=encoder_a.Get();   //エンコーダパルス数を取得
         enc_count_b=-encoder_b.Get();
         distance_a=(enc_count_a*PULSE_TO_UM)/1000;    //移動距離をmm単位で格納
         distance_b=(enc_count_b*PULSE_TO_UM)/1000;    
         PC.printf("dis_a:%d   dis_b:%d\r\n",distance_a,distance_b);//表示
         wait(0.5);
    }
 }
