//モータドライバTB6612動作検証用のサンプルプログラム
//TB6612クラスを使用して、モータA,モータBのオブジェクトを生成する。
//生成時のピン割当はマイコンピン割当通りに配置すること。
#include "mbed.h"
#include "TB6612.h"
TB6612      motor_a(D2,D7,D6);  //モータA制御用(pwma,ain1,ain2)
TB6612      motor_b(D10,D8,D9);  //モータB制御用(pwmb,bin1,bin2)
Serial      pc(USBTX,USBRX);    //USBシリアル通信用

int main() {
    float   motor_speed;        //モータスピード情報格納用
    char    input_data;         //キーボード入力情報格納用
    while(1) {
        input_data=pc.getc();   //キーボード入力情報取得
        motor_speed=0.5; //モータスピード(低速運転させるため２分の１の値とする。)
        switch(input_data){
            case    '1':    motor_a=motor_speed;    //モータA正転
                            break;    
            case    '2':    motor_a=0;              //モータAブレーキ
                            break;
            case    '3':    motor_a=-motor_speed;   //モータA逆転
                            break;                                        
            case    '7':    motor_b=motor_speed;    //モータB正転
                            break;    
            case    '8':    motor_b=0;              //モータBブレーキ
                            break;
            case    '9':    motor_b=-motor_speed;   //モータB正転
                            break;              
            default    :    motor_a=0;
                            motor_b=0;              //両方モータブレーキ
                            break;        
        }
    }
}
