/************************************
個人で設定する調整パラメータ

************************************/

////////機体速度関連
#define     LOW_SPEED                875     //標準速度[mm/sec]
#define     MEDIUM_SPEED            1050     //2走目の中間速度[mm/sec]
#define     HIGH_SPEED              1175    //2走目の高速速度[mm/sec]
#define     STOP_DISTANCE         200000     //停止距離200000[um]⇒20[cm]
#define     TURN_POWER              0.6f     //コースアウト時の旋回力


///////マーカ判定関連
#define     DEFAULT_GRAY            0.2f     //フォトリフレクタデジタル入力の閾値
                                             //シリアル通信でSensor_Digital値を確認し調整する。
#define     MARKER_WIDTH            7400     //マーカ幅[um]（ビニルテープ幅19000[um]以内）
                                             //コースの傷によってマーカ誤検知する場合は値を大きくする。
#define     CROSS_JUDGE                4     //ラインセンサいくつ以上白線検知で交差点認識するか設定。


//////ブレーキングシステム調整
#define     HIGH_SPEED_SECTION      1.25f     //最高速度の左右回転差の上限倍率     1.25f
#define     MEDIUM_SPEED_SECTION    1.5f     //中間速度の左右回転差の上限倍率     1.5f
#define     LOW_SPEED_SECTION       2.0f     //最低速度の左右回転差の上限倍率     2.0f
#define     HL_BREAK_DISANCE       230750    //高速度で次のカーブが低速カーブのときのブレーキング距離[um]
#define     HM_BREAK_DISANCE       110000    //高速度で次のカーブが中間速度カーブのときのブレーキング距離[um]
#define     ML_BREAK_DISANCE       37500     //中間速度で次のカーブが低速カーブのときのブレーキング距離[um]


//////各種PD調整
//モータ速度のゲイン関連(むやみに調整しない)
#define     M_KP                  0.002f     //P(比例)制御成分
#define     M_KD                  0.001f     //D(微分)制御成分

//フォトリフレクタのゲイン（外側に行くにつれ値を何倍させたいか調整する。）
#define     S_K1                    1.0f     //float演算させる値には必ずfを付ける
#define     S_K2                    2.0f     //2倍
#define     S_K3                    3.0f     //3倍


//ラインセンサ各種制御成分
//P成分
#define     S_KP_LOW                2.9f     //低速P成分 3.0f
#define     S_KP_MEDIUM             2.4f     //中速P成分 2.0f 
#define     S_KP_HIGH               1.6f     //高速P成分 1.0f

#define     S_KP_DEFAULT_HIGH       2.4f     //3走目P成分 2.0f

//D成分
#define     S_KD_LOW                15.4f    //低速D成分 15.0f
#define     S_KD_MEDIUM             7.6f    //中速D成分 10.0f 
#define     S_KD_HIGH               5.7f     //高速D成分 5.0f

#define     S_KD_DEFAULT_HIGH       5.6f     //3走目D成分 1.0f
//////////☆★☆★☆★☆★☆★//////////////
