/************************************
個人で設定する調整パラメータ

************************************/

////////機体速度関連
#define     LOW_SPEED                750     //標準速度[mm/sec]
#define     MEDIUM_SPEED             850     //2走目の中間速度[mm/sec]
#define     HIGH_SPEED              1150     //2走目の高速速度[mm/sec]
#define     STOP_DISTANCE         200000     //停止距離200000[um]⇒20[cm]
#define     TURN_POWER              0.4f     //コースアウト時の旋回力


///////マーカ判定関連
#define     DEFAULT_GRAY            0.25f     //フォトリフレクタデジタル入力の閾値
                                             //シリアル通信でSensor_Digital値を確認し調整する。
#define     MARKER_WIDTH            8000     //マーカ幅[um]（ビニルテープ幅19000[um]以内）
                                             //コースの傷によってマーカ誤検知する場合は値を大きくする。
#define     CROSS_JUDGE                4     //ラインセンサいくつ以上白線検知で交差点認識するか設定。


//////ブレーキングシステム調整
#define     HIGH_SPEED_SECTION      1.35f     //最高速度の左右回転差の上限倍率     
#define     MEDIUM_SPEED_SECTION    1.65f     //中間速度の左右回転差の上限倍率
#define     LOW_SPEED_SECTION       2.00f     //最低速度の左右回転差の上限倍率
#define     HL_BREAK_DISANCE      200000     //高速度で次のカーブが低速カーブのときのブレーキング距離[um]
#define     HM_BREAK_DISANCE      150000     //高速度で次のカーブが中間速度カーブのときのブレーキング距離[um]
#define     ML_BREAK_DISANCE      100000     //中間速度で次のカーブが低速カーブのときのブレーキング距離[um]



//////各種PD調整
//モータ速度のゲイン関連(むやみに調整しない)
#define     M_KP                  0.002f     //P(比例)制御成分
#define     M_KD                  0.001f     //D(微分)制御成分

//フォトリフレクタのゲイン（外側に行くにつれ値を何倍させたいか調整する。）
#define     S_K1                    1.0f     //float演算させる値には必ずfを付ける
#define     S_K2                    2.0f     //2倍
#define     S_K3                    4.0f     //3倍


//ラインセンサ各種制御成分
//P成分
#define     S_KP_LOW                2.0f     //低速P成分
#define     S_KP_MEDIUM             1.5f     //中速P成分
#define     S_KP_HIGH               1.0f     //高速P成分

#define     S_KP_DEFAULT_HIGH       1.5f     //3走目P成分

//D成分
#define     S_KD_LOW                6.0f     //低速D成分
#define     S_KD_MEDIUM             3.0f     //中速D成分
#define     S_KD_HIGH               2.0f     //高速D成分

#define     S_KD_DEFAULT_HIGH       1.0f     //3走目D成分
//////////☆★☆★☆★☆★☆★//////////////
