/********************************************************



**********************************************************/
////ライントレースサンプル
#include "mbed.h"
#include "CRotaryEncoder.h"
#include "TB6612.h"
#include "AQM0802.h"
#include "tuning.h"
#include "machine.h"

//デジタル入力オブジェクト定義
DigitalIn   push_sw(D13);
/////アナログ入力オブジェクト定義//////////
  
AnalogIn    s1(D3);
AnalogIn    s2(A6);
AnalogIn    s3(A5);
AnalogIn    s4(A4);
AnalogIn    s5(A3);
AnalogIn    s6(A2);
AnalogIn    s7(A1);
AnalogIn    s8(A0);

///////////////////////////////////////  
CRotaryEncoder encoder_a(D1,D0);    //モータAのエンコーダ
CRotaryEncoder encoder_b(D11,D12);  //モータBのエンコーダ
Ticker      timer;                  //タイマ割込み用 
TB6612      motor_a(D2,D7,D6);      //モータA制御用(pwma,ain1,ain2)
TB6612      motor_b(D10,D8,D9);     //モータB制御用(pwmb,bin1,bin2)
AQM0802     lcd(I2C_SDA,I2C_SCL);   //液晶制御用

//使用変数の定義
int         Sw_Ptn      = PULL;     //スイッチの現在情報
int         Old_Sw_Ptn  = PULL;     //スイッチの過去の情報
int         Sw_Cnt = 0;             //スイッチの押された回数
char        Coner_str[3];           //LCD用配列。コーナマーカ通過数表示
            ///各ラインセンサ情報格納用
double      S1_Data,S2_Data,S3_Data,S4_Data,S5_Data,S6_Data,S7_Data,S8_Data; 
double      All_Sensor_Data;        //ラインセンサ総データ量
double      Sensor_Diff[2]={0,0};   //ラインセンサ偏差
double      Sensor_P =0.0f;         //ラインセンサP(比例成分)制御量
double      Sensor_D =0.0f;         //ラインセンサD(微分成分)制御量
double      Sensor_PD=0.0f;         //ラインセンサP,D成分の合計
char        Gray_Str[5];            //LCD閾値表示用文字列
float       Gray=DEFAULT_GRAY;      //白黒のしきい値設定
long int         Enc_Count_A=0,Enc_Count_B=0;    //エンコーダパルス数。現在速度推定に使用する。
long int         Enc_A_Rotate=0,Enc_B_Rotate=0;  //エンコーダパルス数。停止時の機体速度調整に使用。
long int       Stop_Distance=STOP_DISTANCE;    //ストップ時の徐行→停止に使う
long int       Next_Marker_Distance=200000;         //加減速走行時のマーカ間の距離を格納
long int       Recent_Distance=0;              //加減速走行時の次のマーカまでの距離を格納
        /////↓エンコーダパルス数。コース記憶時のエンコーダパルスの蓄積に使用する。
long int         Memory_Enc_Count_A=0,Memory_Enc_Count_B=0;   
char        MemoryA_Str[5];                 //LCD表示用。左モータの走行距離格納
char        MemoryB_Str[5];                 //LCD表示用。右モータの走行距離格納
long int       Distance_A=0,Distance_B=0;      //タイヤ移動距離を格納[mm]。
                                            //機体の現在速度の推定に使用する。タイマ割込みごとにリセットされる。
            ////↓左右タイヤの走行距離格納。1走目のコース記憶処理に使用する。マーカ通過ごとにリセット。                                
long int       Distance_memory_A=0, Distance_memory_B=0;

float       S_Kp=S_KP_LOW;////センサP成分
float       S_Kd=S_KD_LOW;////センサD成分

float       Marker_Run_Distance=0; 
int         Speed_A=0,  Speed_B=0;             //機体の現在速度を格納
int         Low_Speed      = LOW_SPEED;        //2走目以降の低速
int         Medium_Speed   = MEDIUM_SPEED;     //2走目以降の中速
int         High_Speed     = HIGH_SPEED;       //2走目以降の高速
char        Speed_Str[5];                      //LCD速度表示用文字列
int         Target_Speed_A=0,Target_Speed_B=0; //目標速度
int         Motor_A_Diff[2]={0,0};             //過去の速度偏差と現在の速度偏差を格納
int         Motor_B_Diff[2]={0,0};             //
float       Motor_A_P,Motor_B_P;                  //モータ速度制御P成分
float       Motor_A_D,Motor_B_D;                  //モータ速度制御D成分
float       Motor_A_PD,Motor_B_PD;                //モータ速度制御PD合成
float       Motor_A_Pwm,Motor_B_Pwm;              //モータへの出力
unsigned char Sensor_Digital    =0x00;
unsigned char Old_Sensor_Digital=0x00;
int   Sensor_Cnt=0;
unsigned char Machine_Status    =STOP;      //機体状態
unsigned char Old_Machine_Status=0x00;      //過去の機体状態
int Marker_Pass_Flag = 0;                   //マーカ通過中であることを示すフラグ
int Old_Marker_Pass_Flag=0;                 //過去のマーカ通過情報
int Corner_Flag=0;                          //コーナセンサがマーカを検知したことを示すフラグ
int SG_Flag=0;                              //スタート・ゴールセンサがマーカを検知したことを示すフラグ
int SG_Cnt=0;                               //スタート・ゴールセンサのマーカ通過数
int Cross_Flag=0;                           //交差点を通過したことを示すフラグ

int Imaginary_Speed=0;                 //曲率演算にて求めた２走目以降の仮想走行速度
int Next_Imaginary_Speed=0;
long int       course_data[100][3];                  //コース情報の記憶用配列マーカ数は行数分まで対応し、
                                            //列情報は左タイヤ走行距離、右タイヤ走行距離、演算で求めた2走目走行速度を格納する。
int Row=0;                                  //行情報を格納。マーカ通過ごとに加算し、走行終了後リセットされる。
int Marker_Cnt=0;
int Cross_Cnt=0;
int Disp_Cross_Cnt=0;


void sensor_analog_read(){//ラインセンサの情報取得処理。
    if((Sensor_Digital&0x18)||(Cross_Flag==1)){//センサ中央検知もしくは交差点検知のとき
        S1_Data=s1.read();
        S2_Data=0;                  //交差点通過中は急旋回しないようにする。
        S3_Data=s3.read()/S_K2;        //交差点通過中は急カーブを控える
        S4_Data=s4.read(); 
        S5_Data=s5.read(); 
        S6_Data=s6.read()/S_K2;        //交差点通過中は急カーブを控える
        S7_Data=0;                  //交差点通過中は急旋回しないようにする。
        S8_Data=s8.read();  
    }else if(Cross_Flag==0){
        S1_Data=s1.read();
        S2_Data=s2.read(); 
        S3_Data=s3.read();
        S4_Data=s4.read();
        S5_Data=s5.read();
        S6_Data=s6.read();
        S7_Data=s7.read();
        S8_Data=s8.read();                 
    } 
}

//８つのフォトリフレクタの入力を8ビットのデジタルパターンに変換。センサの状態をデジタルパターンで
//扱うために使用する。（if文などの条件式でセンサ情報を使いやすいようにするため）
void sensor_digital_read(){
    Sensor_Cnt=0;
    Old_Sensor_Digital=Sensor_Digital;
    if(S1_Data>Gray){
            Sensor_Digital |= 0x80;   //7ビット目のみセット (1にする。)
    }else   Sensor_Digital &= 0x7F;   //7ビット目のみマスク（0にする。）
    if(S2_Data>Gray){
            Sensor_Digital |= 0x40;   //6ビット目のみセット (1にする。)
            Sensor_Cnt++;
    }else   Sensor_Digital &= 0xBF;   //6ビット目のみマスク（0にする。）
    if(S3_Data>Gray){
            Sensor_Digital |= 0x20;   //5ビット目のみセット (1にする。)
            Sensor_Cnt++;
    }else    Sensor_Digital &= 0xDF;   //5ビット目のみマスク（0にする。）
    if(S4_Data>Gray){
            Sensor_Digital |= 0x10;   //4ビット目のみセット (1にする。)
            Sensor_Cnt++;
    }else    Sensor_Digital &= 0xEF;   //4ビット目のみマスク（0にする。）
    if(S5_Data>Gray){
            Sensor_Digital |= 0x08;   //3ビット目のみセット (1にする。)
            Sensor_Cnt++;
    }else   Sensor_Digital &= 0xF7;   //3ビット目のみマスク（0にする。）
    if(S6_Data>Gray){
            Sensor_Digital |= 0x04;   //2ビット目のみセット (1にする。)
            Sensor_Cnt++;
    }else   Sensor_Digital &= 0xFB;   //2ビット目のみマスク（0にする。）
    if(S7_Data>Gray){
            Sensor_Digital |= 0x02;   //1ビット目のみセット (1にする。)
            Sensor_Cnt++;
    }else   Sensor_Digital &= 0xFD;   //1ビット目のみマスク（0にする。）
    if(S8_Data>Gray){
            Sensor_Digital |= 0x01;   //0ビット目のみセット (1にする。)
    }else   Sensor_Digital &= 0xFE;   //0ビット目のみマスク（0にする。）    
}

//機体の状態をデジタルパターンでセットする関数。モニタリング、条件分岐で
//機体の状態が交差点通過中なのか停止状態なのか判定するために使用する。
void Machine_Status_Set(){
    Old_Machine_Status=Machine_Status; 
       
    //機体がライン中央に位置するとき
    if(Sensor_Digital&RUN_COURSE_CENTER )Machine_Status|=RUN_COURSE_CENTER;
    else Machine_Status &= 0xE7;//ライン中央情報のマスク
    if((Sensor_Digital==0x00)&&(Old_Sensor_Digital==0x40)&&(Cross_Flag==0)){//左センサコースアウト時
        Machine_Status|=RUN_COURSE_LOUT;//左コースアウト状態のビットをセット
    }else if((Machine_Status&RUN_COURSE_LOUT)&&(Sensor_Digital&RUN_COURSE_CENTER)){
        //左コースアウト状態かつ機体がライン中央に復帰したとき
        Machine_Status &= 0xDF;//左コースアウト情報のみマスク    
    }
    if((Sensor_Digital==0x00)&&(Old_Sensor_Digital==0x02)&&(Cross_Flag==0)){//右センサコースアウト時
        Machine_Status|=RUN_COURSE_ROUT;//右コースアウト状態のビットをセット
    }else if((Machine_Status&RUN_COURSE_ROUT)&&(Sensor_Digital&RUN_COURSE_CENTER)){
        //右コースアウト状態かつ機体がライン中央に復帰したとき
        Machine_Status &= 0xFB;//右コースアウト情報のみマスク    
    }     
}

//コーナマーカ検知時に動作。
//エンコーダから取得されたパルス数を距離換算し、事前用意した記憶用配列に格納する。
void corner_curvature(){
    course_data[Row][0]=0;//予め配列の情報は初期化しておく。
    course_data[Row][1]=0;//
    Imaginary_Speed=0;
    ////まずはマーカ間の走行距離を取得する。            
    course_data[Row][0]=(Memory_Enc_Count_A*PULSE_TO_UM);//左タイヤのマーカ間の走行距離を格納
    course_data[Row][1]=(Memory_Enc_Count_B*PULSE_TO_UM);//右タイヤのマーカ間の走行距離を格納                
                                
    //左右タイヤの走行距離の差分を用いた曲率演算
             /////左が右の一倍以上かつ左が右の1.2倍以下もしくは右は左の１倍以上かつ右が左の1.2倍以下の時
    if((((course_data[Row][0])>=(course_data[Row][1]*1.0f))&&((course_data[Row][0])<(course_data[Row][1]*HIGH_SPEED_SECTION)))
      || (((course_data[Row][1])>=(course_data[Row][0]*1.0f))&&((course_data[Row][1])<(course_data[Row][0]*HIGH_SPEED_SECTION)))){
        Imaginary_Speed=High_Speed;//高速とする。    
    }else if((((course_data[Row][0])>=(course_data[Row][1]*HIGH_SPEED_SECTION))&&((course_data[Row][0])<(course_data[Row][1]*MEDIUM_SPEED_SECTION)))
      || (((course_data[Row][1])>=(course_data[Row][0]*HIGH_SPEED_SECTION))&&((course_data[Row][1])<(course_data[Row][0]*MEDIUM_SPEED_SECTION)))){
        Imaginary_Speed=Medium_Speed;//中カーブは中速とする。
    }else if((((course_data[Row][0])>=(course_data[Row][1]*MEDIUM_SPEED_SECTION))&&((course_data[Row][0])<(course_data[Row][1]*LOW_SPEED_SECTION)))
      || (((course_data[Row][1])>=(course_data[Row][0]*MEDIUM_SPEED_SECTION))&&((course_data[Row][1])<(course_data[Row][0]*LOW_SPEED_SECTION)))){
        Imaginary_Speed=Low_Speed;//低速
    }
    else{
        Imaginary_Speed=Low_Speed;//低速
    }                              
    course_data[Row][2]=Imaginary_Speed; //仮想の演算速度を格納
    Memory_Enc_Count_A=0;       //マーカ間の左タイヤエンコーダパルス数のクリア
    Memory_Enc_Count_B=0;       //マーカ間の右タイヤエンコーダパルス数のクリア
    Row++;                  //次のコース情報へ                                                
}

//2走目の加減速走行に使用。1走目で演算したマーカ間の仮想速度を機体目標速度に設定する。
void second_speed_control(void){
    Memory_Enc_Count_A=0;
    Memory_Enc_Count_B=0;
    
    ++Row;
    Next_Marker_Distance=(course_data[Row][0]+course_data[Row][1])/2;    //次のマーカまでの距離を算出
    Next_Imaginary_Speed=course_data[Row+1][2];                          //次のマーカ通過後の速度情報を取得
    if(course_data[Row+1][2]<Low_Speed){//登録されていない速度データだったとき
        Next_Imaginary_Speed=Low_Speed; //標準速度にしておく                
    }else if(course_data[Row+1][2]>High_Speed){
        Next_Imaginary_Speed=High_Speed; //
    }
    
    if(course_data[Row][2]==Low_Speed){     //標準速度区間のとき
        S_Kp=S_KP_LOW;
        S_Kd=S_KD_LOW;        
    }else if(course_data[Row][2]==Medium_Speed){//中速走行区間のとき
        S_Kp=S_KP_MEDIUM;
        S_Kd=S_KD_MEDIUM;        
    }else if(course_data[Row][2]==High_Speed){  //高速走行区間のとき
        S_Kp=S_KP_HIGH;
        S_Kd=S_KD_HIGH;        
    }else{//
        S_Kp=S_KP_LOW;
        S_Kd=S_KD_LOW;         
    }

    if(course_data[Row][2]<Low_Speed){//登録されていない速度データだったとき
        Target_Speed_A=Low_Speed;//安全のため標準速度にしておく
        Target_Speed_B=Low_Speed;         
    }else if(course_data[Row][2]>High_Speed){
        Target_Speed_A=High_Speed;
        Target_Speed_B=High_Speed;            
    }else{
        Target_Speed_A=course_data[Row][2];//記憶走行で演算した仮想速度を使う
        Target_Speed_B=course_data[Row][2];          
    }                                          
}
void second_breaking(){
    Recent_Distance=Next_Marker_Distance
                    -(((Memory_Enc_Count_A*PULSE_TO_UM)+(Memory_Enc_Count_B*PULSE_TO_UM))/2);

    //現在速度がハイスピードで次のコースが急カーブであり、残り距離が---だったとき
    if((course_data[Row][2]==High_Speed)&&(Next_Imaginary_Speed<Medium_Speed)){           
            if(Recent_Distance<(HL_BREAK_DISANCE)){
                Target_Speed_A=Low_Speed;
                Target_Speed_B=Low_Speed;
            }                 
    }
    //現在速度がハイスピードで次のコースが中カーブであり、残り距離が---だったとき
    else if((course_data[Row][2]==High_Speed)&&(Next_Imaginary_Speed==Medium_Speed)){
            if(Recent_Distance<(HM_BREAK_DISANCE)){
                Target_Speed_A=Low_Speed;
                Target_Speed_B=Low_Speed;
            }
    }
    //現在速度が中間速度で次のコースが急カーブであり、残り距離が---だったとき
    else if((course_data[Row][2]==High_Speed)&&(Next_Imaginary_Speed<Medium_Speed)){
            if(Recent_Distance<(ML_BREAK_DISANCE)){
                Target_Speed_A=Low_Speed;
                Target_Speed_B=Low_Speed;
            } 
    }          
}

/////LCD表示用関数。機体の現在状態を表示する。
void display_print(void){
    char lcd_top_str[9],lcd_low_str[9];   //lcd表示用配列を用意   各行分
    //////表示クリア
    lcd.locate(0,0);
    lcd.print("        ");
    lcd.locate(0,1);
    lcd.print("        ");
        
    ////////0行目の表示//////////////////////////////
    sprintf(lcd_top_str,"%d:%d:%03d",Sw_Cnt,Disp_Cross_Cnt,Marker_Cnt);//0行の表示文字の整理
    lcd.locate(0,0);                    //表示位置を0行目にセット
    lcd.print(lcd_top_str);             //表示
    
    ////////1行目の表示/////////////////////////////
    sprintf(lcd_low_str,"SPD:%04d",Low_Speed);        //1行の表示文字の整理
    lcd.locate(0,1);                    //表示位置を1行目にセット
    lcd.print(lcd_low_str);             //表示
}


//タイマ割り込み1[ms]周期
void timer_interrupt(){  
    //ラインセンサ情報取得
    sensor_analog_read();
    sensor_digital_read();
    
    //機体状態の取得
    Machine_Status_Set();
    
    //交差点の認識
    if((Sensor_Cnt>=CROSS_JUDGE)||(Sensor_Digital==0x42))Cross_Flag=1;//ラインセンサ4つ以上検知状態の時は交差点を示す。
    //エンコーダパルス数の取得
    Enc_Count_A=encoder_a.Get();            
    Enc_Count_B=-encoder_b.Get();
    
    //各種マーカの検知
    Old_Marker_Pass_Flag=Marker_Pass_Flag;//過去のフラグを退避
    if(Sensor_Digital&0x81){                   //マーカセンサ検知時
        Marker_Pass_Flag=1;                     //マーカ通過中フラグをON
        if(Sensor_Digital&0x80)Corner_Flag=1;  //コーナセンサの検知
        if(Sensor_Digital&0x01)SG_Flag=1;      //スタートゴールセンサの検知
        if((Corner_Flag==1)&&(SG_Flag==1));//交差点通過中。何もしない    
    }else Marker_Pass_Flag=0;//マーカ通過終了       
 
    //マーカ通過後、マーカ種類判別    
    if((Old_Marker_Pass_Flag==1)&&(Marker_Pass_Flag==0)){//マーカ通過後
        if(Marker_Run_Distance>MARKER_WIDTH){   //マーカ幅がもっともらしいとき
            if((SG_Flag==1)&&(Corner_Flag==1)&&(Cross_Flag==1))Cross_Cnt++;   //交差点数の更新
            else if((SG_Flag==1)&&(SG_Cnt==0)){ //ゴールスタートマーカの時⇒1回目
                SG_Cnt=1;
                if(Sw_Cnt==1){                  //1走目のとき                  
                    corner_curvature();     //曲率に応じた速度推定処理                
                }else if(Sw_Cnt==2){            //2走目のとき                            
                    second_speed_control(); //記憶情報から目標速度を設定する処理                                           
                }else{//3走目は定速で高速走行
                    Target_Speed_A=Low_Speed;
                    Target_Speed_B=Low_Speed;
                }
            }else if((SG_Flag==1)&&(SG_Cnt==1)){//ゴールスタートマーカの時⇒2回目
                Marker_Cnt=Row;                 //マーカカウント数をLCD表示用に退避させる
                Disp_Cross_Cnt=Cross_Cnt;       //ディスプレイ表示用に交差点数を退避させる            
                if(Sw_Cnt==1){
                    corner_curvature();         //曲率に応じた速度推定処理                                     
                }else if(Sw_Cnt==2){                //2走目のとき　　　何もしない
                }else;                          //3走目のとき　　　何もしない                                    
                Machine_Status|=STOP;           //機体停止状態へ                
                Row=0;                          //コース記憶用配列の行情報[通過マーカ情報]の初期化
                Cross_Cnt=0; 
                SG_Cnt=0;                       //スタート・ゴールマーカ情報のリセット   
            }else if(Corner_Flag==1){           //コーナマーカの時  
                if(Sw_Cnt==1){                      //1走目のとき
                    corner_curvature();         //曲率に応じた速度推定処理                                     
                }else if(Sw_Cnt==2){                //2走目のとき             
                    second_speed_control();     //記憶情報から目標速度を設定する処理  へ                                          
                }else{//3走目は定速で高速走行
                    Target_Speed_A=Low_Speed;
                    Target_Speed_B=Low_Speed;
                }                                                              
            }
        }else;//マーカではなく、誤検知だった場合。何もしない
                
        //////マーカ通過後は各種マーカ判定用フラグ、パラメータのリセット処理を行う。
        Corner_Flag=0;
        SG_Flag=0;
        Cross_Flag=0;
        Marker_Run_Distance=0;                  //マーカ通過距離情報リセット
        
    }/////////////////各種マーカ判定処理の終了
    //////コース記憶に使用するエンコーダパルス数の蓄積処理
    Memory_Enc_Count_A+=Enc_Count_A;
    Memory_Enc_Count_B+=Enc_Count_B;     
    
    if(Sw_Cnt==2)second_breaking();     //２走目の場合はブレーキングシステムを使用する。   
    
        
    //センサ取得値の重ね合わせ（端のセンサほどモータ制御量を大きくする）
    All_Sensor_Data=-(S2_Data*S_K3+S3_Data*S_K2+S4_Data*S_K1)+(S5_Data*S_K1+S6_Data*S_K2+S7_Data*S_K3);
    Sensor_Diff[1]=Sensor_Diff[0];//過去のラインセンサ偏差を退避
    Sensor_Diff[0]=All_Sensor_Data;
    Sensor_P=All_Sensor_Data*S_Kp;                  //ラインセンサ比例成分の演算       
    Sensor_D=(Sensor_Diff[0]-Sensor_Diff[1])*S_Kd;  //ラインセンサ微分成分の演算
    Sensor_PD=Sensor_P+Sensor_D; 
          
    ////モータ現在速度の取得            
    Distance_A=(Enc_Count_A*PULSE_TO_UM);   //移動距離をmm単位で格納
    Distance_B=(Enc_Count_B*PULSE_TO_UM);
    Speed_A=(Distance_A*1000)/INTERRUPT_TIME;//走行速度演算[mm/s]
    Speed_B=(Distance_B*1000)/INTERRUPT_TIME;
    /////モータの速度制御
    //過去の速度偏差を退避
    Motor_A_Diff[1]=Motor_A_Diff[0];
    Motor_B_Diff[1]=Motor_B_Diff[0];
    //現在の速度偏差を取得。    
    Motor_A_Diff[0]=(Target_Speed_A-Speed_A);
    Motor_B_Diff[0]=(Target_Speed_B-Speed_B);   

    //P成分演算
    Motor_A_P=Motor_A_Diff[0]*M_KP;
    Motor_B_P=Motor_B_Diff[0]*M_KP;
    //D成分演算
    Motor_A_D=(Motor_A_Diff[0]-Motor_A_Diff[1])*M_KD;
    Motor_B_D=(Motor_B_Diff[0]-Motor_B_Diff[1])*M_KD;
    //モータ速度制御のPD合成
    Motor_A_PD=Motor_A_P+Motor_A_D;
    Motor_B_PD=Motor_B_P+Motor_B_D;
    //最終的なモータ制御量の合成    
    Motor_A_Pwm=Motor_A_PD+Sensor_PD;
    Motor_B_Pwm=Motor_B_PD-Sensor_PD;

   //モータ制御量の上限下限設定
    if(Motor_A_Pwm>0.95f)Motor_A_Pwm=0.95f;
    else if(Motor_A_Pwm<-0.95)Motor_A_Pwm=-0.95f;
    if(Motor_B_Pwm>0.95f)Motor_B_Pwm=0.95f;
    else if(Motor_B_Pwm<-0.95f)Motor_B_Pwm=-0.95f;       
    //モータへの出力    
    if(!(Machine_Status&STOP)){//マシンが停止状態でなければ
        if(Machine_Status&RUN_COURSE_LOUT){         //左端センサ振り切れた時
            motor_a=-(-TURN_POWER); //左旋回
            motor_b=-(TURN_POWER);    
        }else if(Machine_Status&RUN_COURSE_ROUT){   //右端センサ振り切れた時
            motor_a=-(TURN_POWER);  //右旋回    
            motor_b=-(-TURN_POWER);
        }else{
            motor_a=-Motor_A_Pwm;
            motor_b=-Motor_B_Pwm;
        }
    }else{//停止状態の時はモータへの出力は無効
        if(Stop_Distance<STOP_DISTANCE){
            motor_a=-Motor_A_Pwm/4;
            motor_b=-Motor_B_Pwm/4;

        }else{
            motor_a=0;
            motor_b=0;
        }
    }
    //////機体停止時の徐行用の走行距離演算
    if(Machine_Status&STOP){//機体停止状態の時
        if(Stop_Distance>=STOP_DISTANCE){
         Enc_A_Rotate+=Enc_Count_A;//閾値用に左エンコーダ値の蓄積 
         Enc_B_Rotate+=Enc_Count_B;//速度用に右エンコーダ値の蓄積                   
        }    
        if(Enc_A_Rotate<-6400)Enc_A_Rotate=-6400;
        if(Enc_A_Rotate>6400)Enc_A_Rotate=6400;        
        if(Enc_B_Rotate<-6400)Enc_B_Rotate=-6400;
        if(Enc_B_Rotate>6400)Enc_B_Rotate=6400;
        if((Distance_A>=0)&&(Distance_B>=0))Stop_Distance+=(Distance_A+Distance_B)/2;        
        if(Stop_Distance<0)Stop_Distance=0;
        if(Stop_Distance>STOP_DISTANCE)Stop_Distance=STOP_DISTANCE;
    }  
    if(Marker_Pass_Flag==1){//マーカ通過中は通過距離情報を蓄積する。
        Marker_Run_Distance+=(Distance_A+Distance_B)/2;
    }
               
        
        
        
    //割込み終了時の各種パラメータリセット処理 
    //エンコーダ関連情報のリセット
    encoder_a.Set(0);//エンコーダクラスのパルス数情報のリセット
    encoder_b.Set(0);
    
    Enc_Count_A = 0;//速度制御用エンコーダパルス数情報のリセット                    
    Enc_Count_B = 0;//
    Distance_A=0;   //速度制御用距離情報のリセット
    Distance_B=0;    
}

int main() { 
    timer.attach_us(&timer_interrupt,INTERRUPT_TIME);//タイマ割り込みスタート 
    lcd.cls();//表示クリア
    
    while(1){
        Old_Sw_Ptn=Sw_Ptn;  //過去のスイッチ入力情報を退避
        Sw_Ptn=push_sw;     //現在のスイッチ入力情報の取得
        display_print();       //LCDに現在の機体状態を表示
        
        if(Machine_Status&STOP){//機体停止状態の時                                 
            Low_Speed=LOW_SPEED+(Enc_B_Rotate/8);      //標準速度調整                
        }    
                 
        if((Old_Sw_Ptn==PULL)&&(Sw_Ptn==PUSH)){//スイッチが押された瞬間
            if(Machine_Status&STOP){//機体停止状態の時
                Sw_Cnt++;
                Memory_Enc_Count_A=0;
                Memory_Enc_Count_B=0;                    
                wait(0.5);
                display_print();       //LCDに現在の機体状態を表示                
                wait(1.5);
                Corner_Flag=0;
                SG_Flag=0;
                Cross_Flag=0;
                Row=0;                          //コース記憶用配列の行情報[通過マーカ情報]の初期化 
                SG_Cnt=0;                       //スタート・ゴールマーカ情報のリセット                   
                Marker_Run_Distance=0;//マーカ通過距離情報リセット                
                if(Sw_Cnt==1){          //1走目のとき
                    S_Kp=S_KP_LOW;    
                    S_Kd=S_KD_LOW;
                    Target_Speed_A=Low_Speed;
                    Target_Speed_B=Low_Speed;                      
                }else if(Sw_Cnt==2){          //2走目のとき
                    S_Kp=S_KP_LOW;    
                    S_Kd=S_KD_LOW;
                    Target_Speed_A=Low_Speed;
                    Target_Speed_B=Low_Speed;                               
                }
                else{              //3走目以降のとき
                    S_Kp=S_KP_DEFAULT_HIGH;     
                    S_Kd=S_KD_DEFAULT_HIGH;
                    Target_Speed_A=Low_Speed;
                    Target_Speed_B=Low_Speed;                                        
                }
                Stop_Distance=0;
                Machine_Status&=0x7F;//ストップ状態解除 
     
            }else{//機体走行中であったとき
                //各種フラグのクリア
                Corner_Flag=0;
                SG_Flag=0;
                Cross_Flag=0;
                Row=0;                          //コース記憶用配列の行情報[通過マーカ情報]の初期化 
                Cross_Cnt=0;
                SG_Cnt=0;                       //スタート・ゴールマーカ情報のリセット                   
                Marker_Run_Distance=0;//マーカ通過距離情報リセット
                Machine_Status |= STOP;//機体停止状態にする。                
            }
        }               
    }
}