/******************************************************************************
 * Developed from
 * VL6180X_demo.ino
 * Example Sketch for VL6180x time of flight range finder.
 * Casey Kuhns @ SparkFun Electronics
 * 10/29/2014
 * https://github.com/sparkfun/ToF_Range_Finder-VL6180_Library
 * 
 * The VL6180x by ST micro is a time of flight range finder that
 * uses pulsed IR light to determine distances from object at close
 * range.  The average range of a sensor is between 0-200mm
 * 
 * Resources:
 * This library uses the Arduino Wire.h to complete I2C transactions.
 * 
 * Development environment specifics:
 *  IDE: Arduino 1.0.5
 *  Hardware Platform: Arduino Pro 3.3V/8MHz
 *  VL6180x Breakout Version: 1.0
 * 
 * 
 * This code is beerware. If you see me (or any other SparkFun employee) at the
 * local pub, and you've found our code helpful, please buy us a round!
 * 
 * Distributed as-is; no warranty is given.
 ******************************************************************************/
#include "mbed.h"
#include <VL6180x.h>
#include "Servo.h"

/*const float GAIN_1    = 1.01;  // Actual ALS Gain of 1.01
const float GAIN_1_25 = 1.28;  // Actual ALS Gain of 1.28
const float GAIN_1_67 = 1.72;  // Actual ALS Gain of 1.72
const float GAIN_2_5  = 2.6;   // Actual ALS Gain of 2.60
const float GAIN_5    = 5.21;  // Actual ALS Gain of 5.21
const float GAIN_10   = 10.32; // Actual ALS Gain of 10.32
const float GAIN_20   = 20;    // Actual ALS Gain of 20
const float GAIN_40   = 40;    // Actual ALS Gain of 40
*/

#define VL6180X_ADDRESS 0x29

Serial pc(SERIAL_TX, SERIAL_RX);

DigitalInOut sda_D(PB_9);
DigitalInOut scl_D(PB_8);


VL6180xIdentification identification;
// mbed uses 8bit addresses shift address by 1 bit left
VL6180x sensor_D(PB_9, PB_8, VL6180X_ADDRESS<<1);

void printIdentification(struct VL6180xIdentification *temp){
  printf("Model ID = ");
  printf("%d\n",temp->idModel);

  printf("Model Rev = ");
  printf("%d",temp->idModelRevMajor);
  printf(".");
  printf("%d\n",temp->idModelRevMinor);

  printf("Module Rev = ");
  printf("%d",temp->idModuleRevMajor);
  printf(".");
  printf("%d\n",temp->idModuleRevMinor);  

  printf("Manufacture Date = ");
  printf("%d",((temp->idDate >> 3) & 0x001F));
  printf("/");
  printf("%d",((temp->idDate >> 8) & 0x000F));
  printf("/1");
  printf("%d\n",((temp->idDate >> 12) & 0x000F));
  printf(" Phase: ");
  printf("%d\n",(temp->idDate & 0x0007));

  printf("Manufacture Time (s)= ");
  printf("%d\n",(temp->idTime * 2));
  printf("\n\n");
}
int main() {

 Servo myservo(D7);                // Create the servo object
 float butee_droite=0.1;
 float butee_gauche=1;
 double position=0.1;
 myservo.calibrate(0.00095, 90.0); // Calibrate the servo
 
 pc.baud(115200);

  wait_ms(100); // delay .1s
  sda_D.mode(PullUp);
  scl_D.mode(PullUp);
  //sensor_D.getIdentification(&identification); // Retrieve manufacture info from device memory
  //printIdentification(&identification); // Helper function to print all the Module information

  if(sensor_D.VL6180xInit() != 0){
        printf("FAILED TO INITALIZE\n"); //Initialize device and check for errors
  }; 

  sensor_D.VL6180xDefautSettings(); //Load default settings to get started.
  wait_ms(100); // delay
  
  while(1) {
  
        while(position<butee_gauche){
            myservo.write(position);
            //printf("capteur: %d %f\n", sensor_D.getDistance(), position);
            pc.printf("%d\n\r", sensor_D.getDistance());
            pc.printf("%f\n\r", position);
            wait_ms(10);  
            position = position + 0.01;

        }
        
        myservo.write(butee_droite);
        position = 0.1;
        wait_ms(10);
        
      
  }
}





