#include "mbed.h"
#include "ultrasonic.h"
#include "VL6180x.h"
#include "easyspin.h"

#define VL6180X_ADDRESS 0x29

Easyspin myEasyspin;
DigitalInOut sdaDummy(D14);
DigitalInOut sclDummy(D15);

VL6180xIdentification identification;
// mbed uses 8bit addresses shift address by 1 bit left
VL6180x sensor(D14, D15, VL6180X_ADDRESS<<1);

int main()
{
    sdaDummy.mode(PullUp);
    sclDummy.mode(PullUp);
    myEasyspin.Begin(2);
    while(1) {
        if(sensor.getDistance()<255) {
            myEasyspin.Run(0, FORWARD);
            myEasyspin.Run(1, FORWARD);
        } else {
            myEasyspin.Run(0, FORWARD);
            myEasyspin.Run(1, BACKWARD);
        }
        wait_ms(200);
    }
}
