#include "mbed.h"
#include "ultrasonic.h"
 
DigitalOut myled(LED1);
 
#include "debug.h"
#include "btle.h"
//#include "BlueNRGDevice.h"//User does not use any platform specific header file
#include "BLEDevice.h"
#include "UUID.h"
#include "Utils.h"
 
BLEDevice dev;
 
const static char  DEVICE_NAME[] = "FearInProgress";
const uint8_t device_address[6] = { 0x07, 0x07, 0x07, 0x07, 0x07, 0x07 }; //Peripheral address
//InterruptIn event_button(USER_BUTTON);
volatile bool go_to_sleep = true;

#define MAX_SERVICES_NOS 1                                                                                                                                   


static uint8_t mm[2] = {0x00, 0x00};
static uint8_t upd[2] = {0x00, 0x00};
 
GattCharacteristic proxLevel(GattCharacteristic::UUID_ALERT_LEVEL_CHAR, mm, sizeof(mm), sizeof(mm), 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_NOTIFY|GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ
                            /*GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_INDICATE*/);
 
GattCharacteristic updateRate(GattCharacteristic::UUID_MEASUREMENT_INTERVAL_CHAR , upd, sizeof(upd), sizeof(upd), 
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE_WITHOUT_RESPONSE|
                            GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_WRITE|GattCharacteristic::BLE_GATT_CHAR_PROPERTIES_READ);                            
 
GattCharacteristic *proxChars[] = {&proxLevel, &updateRate };
//UUID PROXSERVICE(GattService::UUID_IMMEDIATE_ALERT_SERVICE);
GattService proxService(GattService::UUID_IMMEDIATE_ALERT_SERVICE, proxChars, sizeof(proxChars) / sizeof(GattCharacteristic *));
 
static const uint16_t uuid16_list[] = {GattService::UUID_IMMEDIATE_ALERT_SERVICE};

void dist(int distance)
{
    //if (dev.getGapState().connected) {
    mm[0] = distance & 0xff;
    mm[1] = (distance >> 8);
    dev.updateCharacteristicValue(proxLevel.getHandle(), mm, sizeof(mm));
    //}
    DEBUG("%d%d Distance changed to %dmm\r\n", mm[1], mm[0], distance);
}

void ISR_pressed()                      // ISR for the button press
{
    DEBUG("Button pressed\n");         // Show that the button has pressed
    go_to_sleep = !go_to_sleep;         // Toogle the sleep state
    //mu.checkDistance();
    //event_button.disable_irq();         // Disable the interrupt request
}

void disconnectionCallback(uint16_t Handle_t)
{
    DEBUG("Disconnected!\n\r");
    DEBUG("Restarting the advertising process\n\r");
    dev.startAdvertising();
}
 
void onWriteCallback(uint16_t attributeHandle) {
    DEBUG("Write Callback!!\n\r");
    }
    
void onConnectionCallback(uint16_t Handle_t) {
    //myled = 1; // LED is ON
    DEBUG("Connected BlueNRG!!\n\r");
    }
 
 
void onNotifyEnabled(uint16_t charHandle) {
    //myled = 1; // LED is ON
    DEBUG("onNotifyEnabled!!\n\r");
    }
    
void onNotifyDisabled(uint16_t charHandle) {
    //myled = 1; // LED is ON
    DEBUG("onNotifyDisabled!!\n\r");
    }
 
void onDataSentNotify() {
    //myled = 1; // LED is ON
    DEBUG("on Data Sent Notify!!\n\r");
    }
 
 
/**
 * Triggered periodically by the 'ticker' interrupt; updates hrmCounter.
 */
void periodicCallback()
{
}
 
int main() {   
    
    //Ticker ticker; //For Tick interrupt if used later on (periodic data updates?)
    //event_button.mode(PullUp);          // Setup the internall pull-up resistor
    //event_button.fall(&ISR_pressed);    // Set the ISR associated to event fall (push the button)
    //ticker.attach(periodicCallback, 1);

    myled = 0;//Switch OFF LED1
     
    DEBUG("Initializing BlueNRG...\n\r");
    dev.init();
    
    dev.onConnection(onConnectionCallback);
    dev.onDisconnection(disconnectionCallback);
    dev.onDataWritten(onWriteCallback);
    dev.onUpdatesEnabled(onNotifyEnabled);
    dev.onDataSent(onDataSentNotify);
    dev.onUpdatesDisabled(onNotifyDisabled);
    
    dev.setAddress(Gap::ADDR_TYPE_PUBLIC, device_address);//Will reset the device and re-init()

    /* setup advertising */
    dev.accumulateAdvertisingPayload(GapAdvertisingData::BREDR_NOT_SUPPORTED | GapAdvertisingData::LE_GENERAL_DISCOVERABLE);
    dev.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LIST_16BIT_SERVICE_IDS, (uint8_t*)uuid16_list, sizeof(uuid16_list));
    dev.accumulateAdvertisingPayload(GapAdvertisingData::COMPLETE_LOCAL_NAME, (uint8_t *)DEVICE_NAME, sizeof(DEVICE_NAME));
    dev.setAdvertisingType(GapAdvertisingParams::ADV_CONNECTABLE_UNDIRECTED);
    dev.setAdvertisingInterval(160); /* 100ms; in multiples of 0.625ms. */
    DEBUG("Starting Advertising...\n\r");
    dev.startAdvertising();
    dev.addService(proxService);
    ultrasonic mu(D8, D9, .1, 1, &dist);    
    mu.startUpdates();
    
    while(1) {
        /*
        if(go_to_sleep)
        {
            myled = 0;
            event_button.enable_irq();  // Enable the interrupt request
            //sleep();                  // Enter Low Power Mode
            deepsleep();                // Enter Low Power Mode (deep)
            wait_ms(200);               // Wait 200ms for debounce
            event_button.enable_irq();  // Enable the interrupt request
        }*/
        //else
        mu.checkDistance();  
        myled = 1;
        wait(1);
        periodicCallback();//Works from here!!
        dev.waitForEvent();
    }
}
