/*LAB_DCMotor*/
#include "mbed.h"
 
//LED1 = D13 = PA_5 (LED on Nucleo board)

//The number will be compiled as type "double" in default
//Add a "f" after the number can make it compiled as type "float"
#define Ts      0.01f    //period of timer1 (s)
#define Kp_1    0.000f
#define Ki_1    0.0001f
#define Kp_2    0.000f
#define Ki_2    0.0001f
 
PwmOut pwm1(D7);
PwmOut pwm1n(D11);
PwmOut pwm2(D8);
PwmOut pwm2n(A3);
 
DigitalOut led1(A4);
DigitalOut led2(A5);
 
//Motor1 sensor
InterruptIn HallA_1(A1);
InterruptIn HallB_1(A2);
//Motor2 sensor
InterruptIn HallA_2(D13);
InterruptIn HallB_2(D12);
 
Serial bluetooth(D10, D2);
Serial pc(D1, D0);
 
Ticker timer1;
void timer1_interrupt(void);
void CN_interrupt(void);
 
void init_TIMER(void);
void init_PWM(void);
void init_CN(void);

int8_t  stateRead(int8_t stateA, int8_t stateB);
 
int8_t stateA_1=0, stateB_1=0, stateA_2=0, stateB_2=0;
int8_t state_1 = 0, state_1_old = 0, state_2 = 0, state_2_old = 0;
 
int v1Count = 0;
int v2Count = 0;
 
float v1 = 0.0, v1_ref = 0.0;
float v1_err = 0.0, v1_ierr = 0.0, PIout_1 = 0.0, PIout_1_old = 0.0;
float v2 = 0.0, v2_ref = 0.0;
float v2_err = 0.0, v2_ierr = 0.0, PIout_2 = 0.0, PIout_2_old = 0.0;
 
int main() {
    bluetooth.baud(115200);
    pc.baud(57600);
    
    init_TIMER();
    init_PWM();
    init_CN();
    
    v1_ref = 0.0;
    v2_ref = 0.0;
        
    led1 = 1;
        
    while(1) 
    {
        if(bluetooth.readable())
        {
            switch(bluetooth.getc())
            {
                case 'q':
                case 'Q':
                    v1_ref = -120.0;
                    break;
                case 'w':
                case 'W':
                    v1_ref = -60.0;
                    break;
                case 'e':
                case 'E':
                    v1_ref = 0.0;
                    break;
                case 'r':
                case 'R':
                    v1_ref = 60.0;
                    break;
                case 't':
                case 'T':
                    v1_ref = 120.0;
                    break;
                    
                case 'a':
                case 'A':
                    v2_ref = -120.0;
                    break;
                case 's':
                case 'S':
                    v2_ref = -60.0;
                    break;
                case 'd':
                case 'D':
                    v2_ref = 0.0;
                    break;
                case 'f':
                case 'F':
                    v2_ref = 60.0;
                    break;
                case 'g':
                case 'G':
                    v2_ref = 120.0;
                    break;
            }
            bluetooth.putc(v1_ierr);
        }
    }
}
 
void timer1_interrupt(void)
{
    led1 = !led1;
    //Motor 1
    v1 = (float)v1Count * 100.0f / 12.0f * 60.0f / 29.0f;   //unit: rpm
    v1Count = 0;
    
    ///code for PI control///
    v1_err = (float)v1_ref - v1;
    v1_ierr += (float)v1_err * Ts;  // 0.01 　是 Sampling time
    PIout_1_old = PIout_1;
    PIout_1 = Kp_1 * v1_err + Ki_1 * (float)v1_ierr;
    
    /////////////////////////
    
    if(PIout_1 >= 0.5f)PIout_1 = 0.5f;
    else if(PIout_1 <= -0.5f)PIout_1 = -0.5f;
    pwm1.write(PIout_1 + 0.5f);
    TIM1->CCER |= 0x4;
    
    
    //Motor 2
    v2 = (float)v2Count * 100.0f / 12.0f * 60.0f / 29.0f;   //unit: rpm
    v2Count = 0;
    
    ///code for PI control///
    v2_err = (float)v2_ref - v2;
    v2_ierr += (float)v2_err * Ts;  // 0.01 　是 Sampling time
    PIout_2_old = PIout_2;
    PIout_2 = Kp_2 * v2_err + Ki_2 * (float)v2_ierr;
    
    /////////////////////////
    
    if(PIout_2 >= 0.5f)PIout_2 = 0.5f;
    else if(PIout_2 <= -0.5f)PIout_2 = -0.5f;
    pwm2.write(PIout_2 + 0.5f);
    TIM1->CCER |= 0x40;
}
 
void CN_interrupt(void)
{
    state_1_old = state_1;
    state_2_old = state_2;
    
    //Motor 1
    stateA_1 = HallA_1.read();
    stateB_1 = HallB_1.read();
    state_1  = stateRead(stateA_1, stateB_1);
    
    if((state_1 - state_1_old == 1) || (state_1 - state_1_old == -3))       //Forward
    {v1Count++;}
    else if((state_1 - state_1_old == -1) || (state_1 - state_1_old == 3))  //Inverse
    {v1Count--;}
    else                                                                    //Stop
    {}
    
    
    //Motor 2
    stateA_2 = HallA_2.read();
    stateB_2 = HallB_2.read();
    state_2  = stateRead(stateA_2, stateB_2);
    
    if((state_2 - state_2_old == 1) || (state_2 - state_2_old == -3))       //Forward
    {v2Count++;}
    else if((state_2 - state_2_old == -1) || (state_2 - state_2_old == 3))  //Inverse
    {v2Count--;}
    else                                                                    //Stop
    {}
}
 
void init_TIMER(void)
{
    timer1.attach_us(&timer1_interrupt, 10000);//10ms interrupt period (100 Hz)
}         
   
void init_PWM(void)
{
    pwm1.period_us(50);
    pwm1.write(0.5);
    TIM1->CCER |= 0x4;
    
    pwm2.period_us(50);
    pwm2.write(0.5);
    TIM1->CCER |= 0x40;
}
 
void init_CN(void)
{
    HallA_1.rise(&CN_interrupt);
    HallA_1.fall(&CN_interrupt);
    HallB_1.rise(&CN_interrupt);
    HallB_1.fall(&CN_interrupt);
    
    HallA_2.rise(&CN_interrupt);
    HallA_2.fall(&CN_interrupt);
    HallB_2.rise(&CN_interrupt);
    HallB_2.fall(&CN_interrupt);
    
    stateA_1 = HallA_1.read();
    stateB_1 = HallB_1.read();
    stateA_2 = HallA_2.read();
    stateB_2 = HallB_2.read();
    state_1  = stateRead(stateA_1, stateB_1);
    state_2  = stateRead(stateA_2, stateB_2);
}


int8_t  stateRead(int8_t stateA, int8_t stateB)
{
    int8_t state;
    if(stateA == 0)
    {
        if(stateB == 0)
        {state = 1;}
        else
        {state = 2;}
    }
    else // stateA == 1
    {
        if(stateB == 0)
        {state = 3;}
        else
        {state = 4;}
    }
    return state;
}
