/*LAB_SERVO*/
#include "mbed.h"

PwmOut servo(A0);
Serial bluetooth(D10,D2);
Serial pc(D1,D0);

//LED1 = D13 = PA_5 (LED on Nucleo board)
DigitalOut led1(A4);
DigitalOut led2(A5);
int counter;
int angle = 0;

Ticker timer1;
void timer1_interrupt(void);

void init_TIMER(void);
void init_IO(void); 
void flash(void);

//Variable(s) for internal control
float servo_duty = 0.079;//0.079 +(0.084/180)*angle, -90<angle<90


int main (void)
{    
    init_IO();
    init_TIMER();
    bluetooth.baud(115200); //設定鮑率
    pc.baud(57600);
    
    while(1)
    {
        if(pc.readable())
        {
            bluetooth.putc(pc.getc());
        }
        if(bluetooth.readable())
        {
            pc.putc(bluetooth.getc());
        }
    }       
}

void timer1_interrupt(void)
{   
    counter++;
    if(counter == 100)
    {    
        led1 = 1;
        wait(1);
        led1 = 0;         
    }
    else if(counter == 200)
    {    
        led2 = 1;
        counter = 0;
        wait(1);
        led2 = 0;        
    }
    
 //////code for internal control//////
 
    switch(bluetooth.getc()){
        case 'a':
            angle = 30; 
        break;
        case 'b':
            angle = 60; 
        break;
        case 'c':
            angle = 90; 
        break;
        case 'd':
            angle = 0;
        break;
        
        }
    
    

    servo_duty = 0.079 + (0.084/180)*angle;
    servo.write(servo_duty);
    servo = 1;
    wait(0.1);       
    servo = 0;   
            
 ////////////////////////////////////////////   
    
    if(servo_duty >= 0.121f)servo_duty = 0.121;
    else if(servo_duty <= 0.037f)servo_duty = 0.037;
    servo.write(servo_duty);
}

void init_TIMER(void)
{
    timer1.attach_us(&timer1_interrupt, 10000);//10ms interrupt period (100 Hz)
}
       
void init_IO(void)
{
    counter = 0;
    led1 = 0;
    led2 = 0;
}         
   
void flash(void)
{
    led1 = !led1;
}