#include "mbed.h"              
#include <Map.hpp>

//Variable Declarations

Serial pc(USBTX, USBRX);
SPI mstrEnc1(PB_15, PB_14, PB_13);  //SPI2_MOSI, SPI2_MISO, SPI2_SCLK
SPI mstrEnc2(PC_12, PC_11, PC_10);  //SPI3_MOSI, SPI3_MISO, SPI3_SCLK

DigitalOut csEnc1(PB_12);           //SPI2_SSEL Encoder 1
DigitalOut csEnc2(PA_4);            //SPI3_SSEL Encoder 2

char rx_in = 0, rx_out = 0;

char dataSize = 5;
char array[5];
char arraySize = sizeof(array);
char getData = 0;
char checkData = 0;
char encArr[2]= {255,255};
char encLength = 2;

/////////////////////////////

//Functions

void RX(int data){
    array[checkData] = data;
    checkData++;
    if(checkData == arraySize){
        getData = 1;
        checkData = 0;
    }
}

void RX_INT(){
    int data = pc.getc();
    RX(data);
}

float ConvertAngle(int encData){
    Map map(0, 16383, 0, 359);
    float angle = map.Calculate(encData);
    return angle;
    }

//read encoder of joint 1
float readEnc1(){
    csEnc1 = 0;
    char *arrAdd = &encArr[0];
    int encData = mstrEnc1.write(arrAdd, 2, arrAdd, 2);
    encData = encArr[0] * 256 + encArr[1];
    csEnc1 = 1;
    return ConvertAngle(encData/2);
}

//read encoder of joint 2
float readEnc2(){
    csEnc2 = 0;
    char *arrAdd = &encArr[0];
    int encData = mstrEnc2.write(arrAdd, 2, arrAdd, 2);
    encData = encArr[0] * 256 + encArr[1];
    csEnc2 = 1;
    return ConvertAngle(encData/2);
}


void RX_INT();

//Main

int main() {
    pc.baud(9600);
    pc.attach(&RX_INT, Serial::RxIrq);
    
    csEnc1 = 1;
    csEnc2 = 1;
    
    mstrEnc1.format(14, 3);
    mstrEnc1.frequency(500000);
    mstrEnc2.format(14, 3);
    mstrEnc2.frequency(500000);
    
    
//Program Loop    
    while(true){
        //if(getData == 1){
          //  for(char i = 0; i < arraySize; i++){
//              printf("array[%d] = %d\n", i,array[i]);
            //    pc.putc(array[i]);
            //}
           // pc.putc('A');
          //  getData = 0;
        //}
        float encdat1 = readEnc1();
        float encdat2 = readEnc2();
        printf("enc1 = %.2f, enc2 = %.2f \n\r", encdat1, encdat2);
    }
    
    
    
    
}