#include "mbed.h"
#include <SPISlave.h>

#define LOW 0;
#define HIGH 1;
Serial pc(USBTX, USBRX);

SPISlave slave(PA_7, PA_6, PA_5, PA_15); //MOSI MISO CLK CS

DigitalIn prox1(PA_14);

DigitalOut PUL_1(D3);
DigitalOut DR_1(PC_0);

bool start = false;
int position = 0;
char inputPos = 0;
char check =0;

//drive stepper motor
void drvStepper1(int step){
    if(step >= 0){
        for(int i=0; i<step; i++){
            DR_1 = 1;
            PUL_1 = 1;
            wait_ms(1);
            PUL_1 = 0;
            wait_ms(1);
        }
    }
    else if(step < 0){
        step = -step;
        for(int i=0; i<step; i++){
            DR_1 = 0;
            PUL_1 = 1;
            wait_ms(1);
            PUL_1 = 0;
            wait_ms(1);
        }
    }
}

int main() {
      pc.baud(9600);
      slave.format(8,3);
      slave.frequency(1000000);
      slave.reply(0x00);              // Prime SPI with first reply
    while(1) {\
        //check data from master
        if(slave.receive()){
            int data = slave.read();
            if(data == 123){
                slave.reply(0x42); //send 'B'
                start = true;
            }
        }
        if(start == true){
        //drive stepper motor
        while(prox1 == 1){
            for(int i=0; i<200; i++){
                DR_1 = 1; //1=down
                PUL_1 = 1;
                wait_ms(1);
                PUL_1 = 0;
                wait_ms(1);
                printf("1\n");
            }   
        }
        wait(1);
        printf("0\n");
        for(int i=0; i<1700; i++){
            DR_1 = 0; //1=down
            PUL_1 = 1;
            wait_ms(1);
            PUL_1 = 0;
            wait_ms(1);
            printf("1\n");
        }
}
