#include "mbed.h"
#include "m3pi.h"

m3pi m3pi;
Serial device(p28, p27);
DigitalIn pushbutton(p21);
DigitalIn IR_centre(p8);
DigitalIn IR_right(p11);
DigitalIn IR_left(p30);
DigitalOut led1(p20);

void forward(float speed)
{
    m3pi.right_motor(speed);
    m3pi.left_motor(speed);
}

void backward(float speed)
{
    m3pi.right_motor(-speed);
    m3pi.left_motor(-speed);
}

void turnright(float speed)
{
    m3pi.right_motor(speed);
    m3pi.left_motor(-speed);
}

void turnleft(float speed)
{
    m3pi.right_motor(-speed);
    m3pi.left_motor(speed);
}

void stop()
{
    m3pi.right_motor(0);
    m3pi.left_motor(0);
}

int main()
{
    device.baud(115200);
    float speed = 0.5;
    char c = 'k', a;
    while(true) 
    {
        if(device.readable())
        {
            a = device.getc();
            if(a > 0 && a <= 100) speed = a*1.0/100;
            else c = a;
        }
        
        if(c == 'g') forward(speed);
        else if(c == 'h') backward(speed);
        else if(c == 'e') turnright(speed);
        else if(c == 'f') turnleft(speed);
        else stop();
    }
}