#include "mbed.h"
#include "C12832.h"

BusOut leds(LED1,LED2,LED3,LED4);  // this is the bus out of leds, so all the leds can be control in one time
C12832 lcd(p5, p7, p6, p8, p11);
Ticker Timer_100ms;        // a ticker is similar to a interrupt
int count=180;

void Countdown(void) // this is what is inside the ticker will do
{
count--;
}
     
int main() {

    Timer_100ms.attach(&Countdown, 1);             //Call Countdown every 1 second *** format: ticker_name.attach(&void_name,time)
    lcd.cls();                                  //clear screen
    while(1)
    {       
        lcd.cls();
        lcd.locate(0,0);                                
        lcd.printf("%d",count);                 //countdown number will display on LCD
        wait(.1);
        if(count==0)
        {
            Timer_100ms.detach();       // this will disable the ticker
            count=180;                  // reset the count
            leds=0xFFFF;                //leds all will light up with the hex number of 0xFFFF
        }
    }       
}