// UART TX RX
#include "mbed.h"

Serial uart_1(D10,D2);           // TX : D10 , RX : D2
PwmOut mypwm(A0);                // A0 : mypwm output

// uart send data
int display[6] = {0,0,0,0,0,0};
char num[14] = {254,255,0,0,0,0,0,0,0,0,0,0,0,0};      // char num[0] , num[1] : 2 start byte

void init_TIMER(void);
void timer1_interrupt(void);
void init_uart(void);
void separate(void);

Ticker timer1;

int main() 
{
    init_TIMER();
    init_uart();
    mypwm.period_ms(20);      // 設mypwm週期為20ms
    mypwm.write(0.05);        // 0 deg
    // duty = 0.05 + (0.05/90)*angle
    while(1) 
    {
        if(uart_1.readable())
        {
            switch(uart_1.getc())
            {
                case 'a':
                    mypwm.write(0.05 + (0.05/90)*0);        // 轉0度
                    break;
                case 'b':
                    mypwm.write(0.05 + (0.05/90)*45);       // 轉45度
                    break;
                case 'c':
                    mypwm.write(0.05 + (0.05/90)*90);       // 轉90度
                    break;
                default:
                    mypwm.write(0.05 + (0.05/90)*0);        // 轉0度
                    break;
            }
        }
    }
}

int i = 0;
void timer1_interrupt()
{
    // uart send data
    display[0] = 10;
    display[1] = 20;
    display[2] = 30;
    display[3] = 40;
    display[4] = 50;
    display[5] = 60;    
    
    separate();
    
    int j = 0;
    int k = 1;
    while(k)
    {
        if(uart_1.writeable())
        {
            uart_1.putc(num[i]);
            i = i + 1;
            j = j + 1;
        }
        
        if(j>1)
        {
            k = 0;
            j = 0;
        }
    }
    
    if(i>13)
        i = 0;
}

void init_TIMER()
{
    timer1.attach_us(&timer1_interrupt, 1000.0);    // 1 ms interrupt period (1 kHz)
}

void init_uart()
{
    uart_1.baud(115200);      // 設定baudrate
}

void separate(void)
{
    num[2] = display[0] >> 8;           // HSB(8bit)資料存入陣列
    num[3] = display[0] & 0x00ff;       // LSB(8bit)資料存入陣列
    num[4] = display[1] >> 8;          
    num[5] = display[1] & 0x00ff;
    num[6] = display[2] >> 8;          
    num[7] = display[2] & 0x00ff;
    num[8] = display[3] >> 8;          
    num[9] = display[3] & 0x00ff;
    num[10] = display[4] >> 8;          
    num[11] = display[4] & 0x00ff;
    num[12] = display[5] >> 8;          
    num[13] = display[5] & 0x00ff;                   
}
