// Header file for functions.cpp

// Speed adjustment to take into account different motor speeds
// Changes speed of left motor
#define ADJUSTMENT 0.1

// Global parameters
// Speed at which it moves forward
// optimum value: 0.4 to 0.8
extern float forwardspeed;
// Global parameters
// Speed at which it reverses
// optimum value: 0.4 to 0.6
extern float reversespeed;
// Speed at which it rotates to find an object
// optimum value: 0.3 to 0.5
extern float searchspeed;
// Range of detection
// optimum value: 30 to 50
extern unsigned int range;



void flash_leds();
void turn_led_on(int LED);
void turn_leds_on();
void turn_led_right();
void turn_led_left();
int read_line1();
int read_line2();
int detect_line();
void move_random(float speed = forwardspeed);
void reverse(float speed = reversespeed, float adj = ADJUSTMENT);
void turn_left(float speed = forwardspeed);
void turn_right(float speed = forwardspeed);
void reverse_and_turn(float speed = reversespeed);
void forwards(float speed = forwardspeed, float adj = ADJUSTMENT);
void stop();
int detect_object(int range_t = range, float speed = searchspeed);
void move_detect(float speed, int fwd_bck, int time, int wait=0);