// Code written by:
// Jon Baker
// Alessandro Grande
// Abdul-Rehman Sharif
// Lucinda Hartfield

// Circuitry made by:
// Jon Baker
// Yucando Navarrete
// Vivekanand Gupta

// The following code controls a robotic car
// by detetecting an object and charging towards it.
// It uses the following basic functions:
//
// forwards(speed)
//                      -   Sets the motor speeds in order to go forwards.
//
// reverse(speed)
//                      -   Sets the motor speeds in order to go backwards.
//
// turn_left(speed)
//                      -   Sets the motor speeds to turn the robot to the left.
//
// turn_right(speed)
//                      -   Sets the motor speeds to turn the robot to the right.
//
// stop()
//                      -   Sets the motor speeds to 0.
//
// turn_led_on(LED)
//                      -   Turns on the LED on the mbed specified by the 
//                          number passed as the argument
//                              Values need to be between 1 and 4
//
// detect_object(range, speed)
//                      -   Used to detect an object, the robot will
//                          move in a circle to find an object. This function
//                          returns 1 if an object is detected, otherwise it will 
//                          return 0. The search will be carried out for 15 seconds.
//
// detect_line ()
//                      -   Used to detect a line, it returns the following values:
//                              0  - if no line is detected
//                              1  - if line detected from the front
//                              -1 - if line detected from the back
//
// move_random(speed)
//                      -   Used to move the robot randomly: the robot will either
//                          move forward, move backward, or turn around. The movement 
//                          will be carried out for a random time.
//

// Libraries for using the above functions and more ...
#include "mbed.h"
#include "Motor.h"
#include "hcsr04.h"
#include "functions.h"

// Set for debugging purpose
// Example: pc(TX, RX)
//Serial pc(USBTX, USBRX);

// Global parameters

float forwardspeed;
float reversespeed;
float searchspeed;
unsigned int range;

void initialise()
{
    // Each speed value can be set from 0 to 1
    
    // Speed at which it moves forward
    // optimum value: 0.5 to 0.8
    forwardspeed = 0.6;
    // Speed at which it reverses
    // optimum value: 0.4 to 0.6
    reversespeed = 0.5;
    // Speed at which it rotates to find an object
    // optimum value: 0.4 to 0.6
    searchspeed = 0.5;
    // Range of detection
    // optimum value: 30 to 50
    range = 30;

    // Wait for 5 seconds to move away from robot
    wait(5);
}

// The main loop - please write your code here
int main()
{
    // Initialise the code
    initialise();

    printf("Starting the robot...");

    Timer t;
    t.start();

    int detect_l = 0;
    int detect_o = 0;

    while(true) {
        // Sample code to detect and object and move_forward at it
        
        wait(1);
        
        detect_o = detect_object(range, searchspeed);

        if (detect_o == 1) {

            forwards(forwardspeed);

            while (true) {

                detect_l = detect_line();
                // If line is detected from front then reverse
                if(detect_l == 1 || detect_l == -1) {
                    stop();
                    turn_led_right();
                    reverse(reversespeed);
                    wait(1);
                    detect_l = 0;
                    break;
                }
            }

        } else {

            move_random();

        }

        detect_o = 0;
        stop();
    } 
}

