// Code written by:
// Jon Baker
// Alessandro Grande
// Abdul-Rehman Sharif
// Lucinda Hartfield

// Circuitry made by:
// Yucando Navarrete
// Vivekanand Gupta

// The following code will control a robotic car
// by detetecting an object and charging towards it
// it uses basic functions as:
//
// charge(speed)        
//                      -   used to charge on an object detected 
//                          the robot will move in a straight line
//                          until it detects the arena line where
//                          it will use reverse() to move back
//
// detect_object(range, speed)
//                      -   used to detect an object, the robot will
//                          move in a circle to find an object and 
//                          return 1 if it finds something and return
//                          0 if it does not find anything - the search
//                          will be carried out for 10 seconds.
//
// detect_line ()       
//                      -   used to detect a line, it returns the following
//                          an int value as follows:
//                          0  - if no line is detected
//                          1  - if line detected from the front
//                          -1 - if line detected from the back
//
// reverse(speed)       
//                      -   reverses the robot with chargespeed in same position

// reverseandturn(speed)     
//                      -   reverses whie moving in a circular direction
//

// Libraries for using the above functions and more ...
#include "mbed.h"
#include "Motor.h"
#include "hcsr04.h"
#include "functions.h"

// Set for debugging purpose
// Example: pc(TX, RX)
//Serial pc(USBTX, USBRX);


// Global parameters
// Speed at which it charges an object
// optimum value: 0.4 to 0.8
float chargespeed;
// Speed at which it rotates to find an object
// optimum value: 0.3 to 0.5
float searchspeed;
// Range of detection
// optimum value: 30 to 50
unsigned int range;

void initialise() {
    chargespeed = 0.6;
    searchspeed = 0.5;   
    range = 30;
    
    // Wait for 5 seconds to move away from robot
    wait(5);
}

// The main loop - please write your code here
int main() {
    // Initialise the code
    initialise();

    printf("Starting the robot...");

    Timer t;
    t.start();
    
    int detect_l = 0;
    int detect_o = 0;

    while(1) {
        // Sample code to detect and object and charge at it
        
        detect_o = detect_object(range, searchspeed)
        
        if (detect_o == 1) {
            
            charge(chargespeed);

            while (true) {
              
                detect_l = detect_line();
                // If line is detected from front then reverse
                if(detect_l == 1) {
                    reverse(searchspeed);
                    wait(2);
                    stop();
                    detect_l = 0
                    break;
                    // If line is detected from back just keep on moving forward
                } else if (detect_l == -1) {
                    wait(2);
                    stop();
                    detect_l = 0
                    break;
                }
            }
            
        } else {
            
            moverandom();
            
        }
        
        detect_o = 0;
        stop();
    }
}

