#ifndef FAHREN_H_
#define FAHREN_H_

#include <mbed.h>
#include "EncoderCounter.h"
#include "Controller.h"
#include "Regler.h"


class Fahren{
    
    public:    
    Fahren(Controller& controller, EncoderCounter& counterLeft, EncoderCounter& counterRight, Regler& regler); //Konstruktor
    
    virtual ~Fahren();
    
    void geradeausU();
    void geradeausG();
    void rechts90();
    void rechts180();
    void links90();
    void ziel();
    void stopp();                        
    
    
    private:
    Controller& controller;
    EncoderCounter& counterLeft;
    EncoderCounter& counterRight;
    
    //Variablen die in der Klasse Fahren verwendet werden
    double speedRight;
    double speedLeft;
    short initialClicksLeft;
    short initialClicksRight;
    short wegLinks;
    short wegRechts;
    short stopRight;
    short stopLeft;
    float SpeedR;
    float SpeedL;
    static const float PERIOD;
    Regler& regler;
    
    void getSpeed();
    Ticker ticker;
    

};
#endif