
// Deklaration IR Sensoren
// V04.18
// V. Ahlers


#ifndef IRSENSOR_H_
#define IRSENSOR_H_

#include <cstdlib>
#include <mbed.h>

 class IRSensor {
    
    public:
        IRSensor(AnalogIn& IrRight, AnalogIn& IrLeft, AnalogIn& IrFront);
        
        float disR;
        float disL;
        float disF;

        float measR;
        float measL;
        float measF;

        virtual ~IRSensor();
        float readR();
        float readL();
        float readF();
        
        private:
        AnalogIn& IrRight;
        AnalogIn& IrLeft;
        AnalogIn& IrFront;
        static const float PR1;
        static const float PR2;
        static const float PR3;
        static const float PR4;
        static const float PR5;
        static const float PL1;
        static const float PL2;
        static const float PL3;
        static const float PL4;
        static const float PL5;
        static const float PF1;
        static const float PF2;
        static const float PF3;
        static const float PF4;
        static const float PF5;
        
};   

#endif /*IR_H_*/
