/*Roboshark V10
IRSensor.h
Erstellt: V. Ahlers
geändert: V.Ahlers
V.5.18
*/


#ifndef IRSENSOR_H_
#define IRSENSOR_H_

#include <cstdlib>
#include <mbed.h>

 class IRSensor {
    
    public:
        IRSensor(AnalogIn& IrRight, AnalogIn& IrLeft, AnalogIn& IrFront, float dis2R, float dis2L, float dis2F, AnalogIn& LineSensor, DigitalIn& button); 
        
        float disR;
        float disL;
        float disF;
        int IrR;
        int IrL;
        int IrF;

        float measR;
        float measL;
        float measF;
        double Line;

        virtual ~IRSensor();
        float readR();
        float readL();
        float readF();
        int codeR();
        int codeL();
        int codeF();
        void codeB();
        int get_ende();
        int ende;
        
        private:
        AnalogIn& IrRight;
        AnalogIn& IrLeft;
        AnalogIn& IrFront;
        AnalogIn& LineSensor;
        DigitalIn button;
        float dis2R;
        float dis2L;
        float dis2F;
        int BL;
        int roundL;
        int roundR;
        int roundF;
        static const float PR1;
        static const float PR2;
        static const float PR3;
        static const float PR4;
        static const float PR5;
        static const float PL1;
        static const float PL2;
        static const float PL3;
        static const float PL4;
        static const float PL5;
        static const float PF1;
        static const float PF2;
        static const float PF3;
        static const float PF4;
        static const float PF5;
        static const int minIrR;
        static const int minIrL;
        static const int minIrF;
        static const float Period;
        double line;
        bool finish;       
        bool finishLast; 
        Ticker ticker;
        
};   

#endif /*IRSensor_H_*/
