#include <mbed.h>

#include "EncoderCounter.h"
#include "Controller.h"
#include "IRSensor.h"
#include "Fahren.h"

DigitalOut myled(LED1);

DigitalOut led0(PC_8);
DigitalOut led1(PC_6);
DigitalOut led2(PB_12);
DigitalOut led3(PA_7);
DigitalOut led4(PC_0);
DigitalOut led5(PC_9);

AnalogIn distance(PB_1);
DigitalOut enable(PC_1);
DigitalOut bit0(PH_1);
DigitalOut bit1(PC_2);
DigitalOut bit2(PC_3);

IRSensor irSensor0(distance, bit0, bit1, bit2, 0);
IRSensor irSensor1(distance, bit0, bit1, bit2, 1);
IRSensor irSensor2(distance, bit0, bit1, bit2, 2);
IRSensor irSensor3(distance, bit0, bit1, bit2, 3);
IRSensor irSensor4(distance, bit0, bit1, bit2, 4);
IRSensor irSensor5(distance, bit0, bit1, bit2, 5);


DigitalOut enableMotorDriver(PB_2);
DigitalIn motorDriverFault(PB_14);
DigitalIn motorDriverWarning(PB_15);

PwmOut pwmLeft(PA_8);
PwmOut pwmRight(PA_9);

EncoderCounter counterLeft(PB_6, PB_7);
EncoderCounter counterRight(PA_6, PC_7);

Controller controller(pwmLeft, pwmRight, counterLeft, counterRight);

Fahren fahren(controller, counterLeft, counterRight);                           //Reihenfolge!!!!!!!!!!!!!!!!!!! Ultra wichtig

int main()
{

    //controller.setDesiredSpeedLeft(150.0f); // Drehzahl in [rpm]              //DEFAULT VON TOBI
    //controller.setDesiredSpeedRight(-150.0f);                                 //DEFAULT VON TOBI
    enable = 1;
    enableMotorDriver = 1;                                                      // Schaltet den Leistungstreiber ein

    while(1) {

        /*fahren.geradeaus();                                                     //Geradeausfahren aufrufen
        wait(1.0f);
        
        fahren.rechts90();
        wait(1.0f);
                
        fahren.rechts180();
        wait(1.0f);*/
        
        fahren.rechts270();
        wait(1.0f);
    }
}



