#include "Fahren.h"
#include <mbed.h>


//Konstruktor
Fahren::Fahren(Controller& controller, EncoderCounter& counterLeft, EncoderCounter& counterRight):
    controller(controller), counterLeft(counterLeft), counterRight(counterRight)
    
{}
//Dekonstruktor
Fahren::~Fahren() {}



//Implementation der Methode geradeaus fahren
void Fahren::geradeaus(){
    
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 1767;
    wegLinks = 1767;
        
    //Geschwindigkeit
    speedRight = 50;
    speedLeft = 50;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight(speedRight);
    controller.setDesiredSpeedLeft(-(speedLeft));
    
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
    
    
    
//Implementation der Methode 90 Grad Rechtsdrehen
void Fahren::rechts90() {
        
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 881;
    wegLinks = 881;
    
    //Geschwindigkeit
    speedRight = 50;
    speedLeft = 50;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight((speedRight));
    controller.setDesiredSpeedLeft((speedLeft));
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
    
    
    
//Implementation der Methode 180 Grad Rechtsdrehen
void Fahren::rechts180() {
        
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 1755;
    wegLinks = 1755;
    
    //Geschwindigkeit
    speedRight = 50;
    speedLeft = 50;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight((speedRight));
    controller.setDesiredSpeedLeft((speedLeft));
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
    

//Implementation der Methode 180 Grad Rechtsdrehen
void Fahren::rechts270() {
        
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 2632;
    wegLinks = 2632;
    
    //Geschwindigkeit
    speedRight = 50;
    speedLeft = 50;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight((speedRight));
    controller.setDesiredSpeedLeft((speedLeft));
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
    
    

