/*Roboshark V6
Fahren.cpp
Erstellt: J. Blunschi
geändert: V.Ahlers
V.5.18
*/

#include "Fahren.h"
#include <mbed.h>
#include "Regler.h"


using namespace std;

const float Fahren :: PERIOD = 0.8f;

//Konstruktor
Fahren::Fahren(Controller& controller, EncoderCounter& counterLeft, EncoderCounter& counterRight, Regler& regler, int reglerEin, IRSensor& iRSensor):
    controller(controller), counterLeft(counterLeft), counterRight(counterRight), regler(regler), reglerEin(reglerEin), iRSensor (iRSensor) {         //IRSENSOR IETAH
    
    SpeedR = 50;
    SpeedL = 50;
    disF = 0;
    ticker.attach(callback(this, &Fahren::getSpeed), PERIOD);
}

//Dekonstruktor
Fahren::~Fahren() {
    ticker.detach();
    }
    

//Korrigierte Geschwindigkeit aus der Klasse Regler aufrufen
void Fahren::getSpeed(){
    if(reglerEin == 1){
    SpeedR = regler.getSpeedR();
    SpeedL = regler.getSpeedL();
    }else {SpeedR = regler.getSpeedR();
            SpeedL = regler.getSpeedL();
    }
    disF = iRSensor.readF();
    //printf("SpeedR in F = %f\n",SpeedR);
    //printf("SpeedL in F = %f\n",SpeedL);
}


//Implementation der Methode geradeaus fahren ungeregelt
void Fahren::geradeausU(){
    
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 1773;
    wegLinks = 1773;
        
    //Geschwindigkeit
    //speedRight = 50;
    //speedLeft = 50;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight(SpeedR);
    controller.setDesiredSpeedLeft(-(SpeedL));
    
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
    
//Implementation der Methode geradeaus fahren geregelt
void Fahren::geradeausG(){
    
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 1788;           //vo 1773
    wegLinks = 1788;            //vo 1773
        
    //Geschwindigkeit
    //speedRight = 50;//SpeedR
    //speedLeft = 50;//SpeedL
    
        
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight(SpeedR);
    controller.setDesiredSpeedLeft(-(SpeedL));
        //printf("SpeedR in F2= %f\n",SpeedR);
        //printf("SpeedL in F2= %f\n",SpeedL);
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts || disF <= 50){
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks || disF <= 50){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }

//Implementation der Methode 90 Grad Rechtsdrehen
void Fahren::rechts90() {
        
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 863;
    wegLinks = 863;
    
    //Geschwindigkeit
    speedRight = 50;
    speedLeft = 50;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight(SpeedR);
    controller.setDesiredSpeedLeft(SpeedL);
    //printf("SpeedR in F = %f\n", SpeedR);
    //printf("SpeedL in F = %f\n", SpeedL);
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
    
    
    
//Implementation der Methode 180 Grad Rechtsdrehen
void Fahren::rechts180() {
        
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 1752;
    wegLinks = 1752;
    
    //Geschwindigkeit
    //speedRight = 50;
    //speedLeft = 50;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight((SpeedR));
    controller.setDesiredSpeedLeft((SpeedL));
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
    

//Implementation der Methode 90 Grad Linksdrehen
void Fahren::links90() {
        
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 878;
    wegLinks = 878;
    
    //Geschwindigkeit
    //speedRight = 50;
    //speedLeft = 50;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight((-SpeedR));
    controller.setDesiredSpeedLeft((-SpeedL));
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
    
        
//Implementation der Methode Ziel erreicht
void Fahren::ziel() {
        
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 7050;
    wegLinks = 7050;
    
    //Geschwindigkeit
    //speedRight = 80;
    //speedLeft = 80;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight((SpeedR));
    controller.setDesiredSpeedLeft((SpeedR));
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;  
            } 
        }
        
    }

//Implementation der Methode stopp
void Fahren::stopp(){
    
    //einlesen des aktuellen Encoder standes
    initialClicksRight = counterRight.read();   
    initialClicksLeft = counterLeft.read();
    
    //Anzahl Clicks die der Encoder zählen soll
    wegRechts = 0;
    wegLinks = 0;
        
    //Geschwindigkeit
    speedRight = 0;
    speedLeft = 0;
    
    //Zustand, dass der Roboter nicht gestoppt hat
    stopRight = false;
    stopLeft = false;
    
    //Drehrichtung der Motoren
    controller.setDesiredSpeedRight(speedRight);
    controller.setDesiredSpeedLeft(-(speedLeft));
    
    
    while(1){
       
       // printf("Encoderrechts %d \n\r", counterRight.read());                   //Debugging Zweck (Putty benutzen!)
       // printf("Encoderlinks %d \n\r", counterLeft.read());                     //Debugging Zweck (Putty benutzen!)
        
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen
        if(counterRight.read() - initialClicksRight >= wegRechts || counterRight.read() - initialClicksRight <= -wegRechts){    
            controller.setDesiredSpeedRight(0);
            stopRight = true;
            }
            
        //If Schleife, wenn Clicks erreicht sind, muss der Motor stoppen    
        if(counterLeft.read() - initialClicksLeft >= wegLinks || counterLeft.read() - initialClicksLeft <= -wegLinks ){
            controller.setDesiredSpeedLeft(0);
            stopLeft = true;
            }
     
        if(stopRight == true && stopLeft == true){
            return;
            }  
         
        }
        
    }
