#include <string>
#include "mbed.h"
#include "mbed_rpc.h"

/**
 *  This example program has been updated to use the RPC implementation in the new mbed libraries.
 *  This example demonstrates using RPC over serial
 */

//Use the RPC enabled wrapped class  - see RpcClasses.h for more info
RpcDigitalOut myled(LED4,"myled");
RpcDigitalOut secondled(LED2,"secondled");

Serial pc(USBTX, USBRX);

// defining a custom function:
void doEchoInput(Arguments* input, Reply* output);
RPCFunction echoInput(&doEchoInput, "echoInput");
 
void doEchoInput(Arguments* input, Reply* output) {
    const char* arg0 = input->getArg<const char*>();
    if (0 == strcmp(arg0, "on")){
        printf("led has been turned on!");
        secondled.write(0);
    }
    else {
        printf("led has been turned off!");
        secondled.write(1);
    }
    
    /*
    // Arguments are already parsed into argv array of char*
    printf("Object name = %s\n",input->obj_name);
    printf("Method name = %s\n",input->method_name);
    for (int i=0; i < input->argc; i++)
        printf("argv[%1d] = %s \n",i,input->argv[i]);
        
    // Alternatively the arguments can be recovered as the types expected
    // by repeated calls to getArg()
    int arg0 = input->getArg<int>();                      // Expecting argv[0] to be int
    printf("Expecting argv[0] to be int = %d\n",arg0);
    float arg1 = input->getArg<float>();                  // Expecting argv[1] to be float
    printf("Expecting argv[1] to be float = %f\n",arg1);
    const char *arg2 = input->getArg<const char*>();      // Expecting argv[2] to be a string
    printf("Expecting argv[2] to be a string = %s\n",arg2);
 
    // The output parameter string is generated by calls to putData, which separates them with spaces.
    output->putData(arg0);
    output->putData(arg1);
    output->putData(arg2);
    */
}
int main() {
    //The mbed RPC classes are now wrapped to create an RPC enabled version - see RpcClasses.h so don't add to base class
    
    // receive commands, and send back the responses
    char buf[256], outbuf[256];
    while(1) {
        pc.gets(buf, 256);
        //Call the static call method on the RPC class
        RPC::call(buf, outbuf); 
        pc.printf("%s\n", outbuf);
    }
}
