#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(PC_11,PC_10,PC_0,PC_3,PC_1,PC_2); // RS, E, D4-D7
Serial pc(USBTX,USBRX,115200);
AnalogIn analog_value(PA_0);
AnalogIn analog_value2(PA_1);
Timer t;

int main() {
    pc.format(8,SerialBase::None,1);
    double meas, meas2, sum, sum2,count =0, range, range2, highscore = 0;
    bool lock = false;
    lcd.cls();
    lcd.printf("Welcome to Speed Testing!");
    
    while(1) {
        t.reset();
        meas = analog_value.read() * 3300;  // Converts and read the analog input value (value from 0.0 to 1.0)
                                            // Change the value to be in the 0 to 3300 range
        meas2 = analog_value2.read() * 3300;
        
        count++;
        sum+=meas;
        range=sum/count;
        sum2+=meas2;
        range2=sum2/count;
        
        if(range > meas)
            range -= 100.0;
        if(range2 > meas2)
            range2 -= 100.0;
        
        while(analog_value.read() * 3300 < range && analog_value2.read() * 3300 < range2);
        if (meas < range && meas2 > range2 && !lock) { // If the value is greater than 2V then switch the LED on
            lock = true;
            t.start();
            while(analog_value2.read() * 3300 > range2);
            t.stop();
            lcd.cls();
            double time = t.read();
            double speed = 7 / time;
            /*
            if(speed > highscore){
                highscore = speed;
                lcd.printf("!!!New record!!!");
                
            }*/
            pc.printf("%f s\n", time);
            pc.printf("%f cm/s\n", speed);
            
        pc.printf("measure1 = %.0f mV, range1 = %.0f mV\n", meas, range);
        pc.printf("measure2 = %.0f mV, range2 = %.0f mV\n", meas2, range2);
        
            lcd.locate(0,0);
            lcd.printf("%f s", time);
            lcd.locate(0,1);
            lcd.printf("%f cm/s", speed);
            lock = false;
        }
    }
}

void animation(){
    lcd.locate(0,1);
    lcd.printf("!*!*!*!*!*!*!*!*");
    wait(0.5);
    lcd.locate(0,1);
    lcd.printf("~!~!~!~!~!~!~!~!");
    wait(0.5);
    lcd.locate(0,1);
    lcd.printf("!~!~!~!~!~!~!~!~");
    wait(0.5);
    lcd.locate(0,1);
    lcd.printf("~!~!~!~!~!~!~!~!");
    wait(0.5);
    lcd.locate(0,1);
    lcd.printf("!~!~!~!~!~!~!~!~");
    wait(0.5);
    lcd.locate(0,1);
    lcd.printf("~!~!~!~!~!~!~!~!");
    wait(0.5);
    lcd.locate(0,1);
    lcd.printf("!~!~!~!~!~!~!~!~");
    wait(0.5);
    lcd.locate(0,1);
    lcd.printf("~!~!~!~!~!~!~!~!");
    lcd.cls();
}