#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(PC_11,PC_10,PC_0,PC_3,PC_1,PC_2); // RS, E, D4-D7
AnalogIn analog_value(PA_0);
Timer t;

int main() {
    double meas, sum, count = 0, range, highscore = 0;
    lcd.cls();
    lcd.printf("Welcome to Speed Testing!");
    
    while(1) {
        meas = analog_value.read() * 3300;  // Converts and read the analog input value (value from 0.0 to 1.0)
                                            // Change the value to be in the 0 to 3300 range
        count++;
        sum+=meas;
        range=sum/count;
        
        if(range > meas)
            range -= 100.0;
            
        //pc.printf("measure = %.0f mV, mean = %.0f mV\n", meas, range);
        if (meas < range) { // If the value is greater than 2V then switch the LED on
          lcd.cls();
          t.start();
          while(analog_value.read()*3300 < range);
          t.stop();
          if(t.read() > 0.0001){
            double time = t.read();
            double speed = 0.25 / time;
            if(speed > highscore){
                highscore = speed;
                lcd.printf("!!!New record!!!");
                lcd.locate(0,1);
                lcd.printf("!!!!!!!!!!!!!!!!");
                wait(3);
            }
            lcd.locate(0,0);
            lcd.printf("%f s", time);
            lcd.locate(0,1);
            lcd.printf("%f m/s", speed);
          }
          else{
            lcd.locate(0,0);
            lcd.printf("Too fast, didn't read =.=");
          }
        }
        t.reset();
    }
}
