#include "mbed.h"
#include "TextLCD.h"
#include "QEI.h"

// BUTTON
InterruptIn button(USER_BUTTON);

// for debugging
//Serial pc(USBTX, USBRX, 115200);

// ENCODER
#define N 1000
QEI wheel(PA_5, PA_6, PA_7, N, QEI::X4_ENCODING); // A, B, Z, pulses/revolution, mode

// 2x16 LCD
TextLCD lcd(PC_11,PC_10,PC_0,PC_3,PC_1,PC_2); // RS, E, D4-D7

void pressed() {
    lcd.printf("Button Pressed\n");
    wheel.reset();
}

int main()
{
    //pc.format(8,SerialBase::None,1);
    button.fall(&pressed);
    lcd.cls();
    lcd.locate(0,0);
    lcd.printf("Wellcome!");
    int p,r;
    while(1) {
        p = wheel.getPulses();
        r = wheel.getRevolutions();
        lcd.locate(0,1);
        lcd.printf("p : %i, r : %i\n",p,r);
        //pc.printf("p : %i, r : %i\n",p,r);
        wait(0.1);
        lcd.cls();
    }
}