#ifndef MOTOR_DRIVE
#define MOTOR_DRIVE

// Mbed Library
#include <cmath>
#include <vector>
#include "OmniWheel.h"

#define M_PI 3.14159265358979323846f

using namespace std;

class MotorDrive {
    private:
        const static double max_rpm = 5000;
        const static double rads_to_rpm = 30.0 / M_PI;
        const static double robot_radius = 0.19;
        const static double wheel_radius = 0.05;
        const static int wheel_num = 3;
        
        double offset_angle;
        double offset_x;
        double offset_y;
        double pwm_coeff;
        double wheel_radius_inv;
        
        OmniWheel omniWheel;
        
        vector<vector<double> > jacobian_matrix;
        
    public:
        // Initialize MotorDrive
        MotorDrive();
        virtual ~MotorDrive();
        // Function
        OmniWheel getOmniWheelData(double linear_x, double linear_y, double angular_z);
};

#endif