#ifndef LSC_SERVO
#define LSC_SERVO
//from mbed
#include "mbed.h"
//from ros
#include "BufferedSerial.h"

#include <vector>

#define LOBOT_SERVO_FRAME_HEADER         0x55
#define LOBOT_SERVO_MOVE_TIME_WRITE      1

using namespace std;


class LSCServo {
    public:
        BufferedSerial serial;
        void receive_buffer(char* destination, int length);
        LSCServo(PinName tx, PinName rx, uint32_t buf_size = 256, uint32_t tx_multiple = 4,const char* name=NULL);
        virtual ~LSCServo();
        void LobotSerialoneServoMove(uint16_t id, int16_t position, uint16_t time);  //control one serial servo move dedicated position
        void LobotSerialServoMove(vector<uint16_t> id, vector<int16_t> position, uint16_t time);  //control list of serial servo move dedicated position
        void LobotSerialActionGroupRun(uint16_t id, uint16_t count);//Run Action Group in multiple time, 0 == infinity
        void LobotSerialActionGroupSpeed(uint16_t id, uint16_t speed);//Set Run speed Action Group in XXX%, 0xFF for all
        int LobotSerialGetBatteryVoltage();//get voltage of board in terms of mV
        void LobotSerialActionGroupStop();//Stop current action group
        void LSCServo::moveServos(uint8_t Num, uint16_t Time, ...);
};
#endif