#include "mbed.h"
#include "QEI.h"
#include "pid.h"

#ifndef DC_MOTOR_CONTROLLER_H
#define DC_MOTOR_CONTROLLER_H

class DC_Motor_Controller
{
    public:
        DC_Motor_Controller(PinName out_M1, PinName out_M2, PinName in_A, PinName in_B, int PPR);        
        void goto_angle(int angle, float speed = 1);
        void reset();
        void move_angle(int angle, float speed = 1);
        void set_out(float a, float b);
        int get_pulse();
    
    protected:
        int _ppr;
        PwmOut out1, out2; 
        QEI dc_motor;
        virtual void goto_pulse(int tar_pulse, float speed = 1) = 0;
};

class DC_Motor_On_Off: public DC_Motor_Controller 
{
    public:
        DC_Motor_On_Off(PinName out_M1, PinName out_M2, PinName in_A, PinName in_B, int PPR):DC_Motor_Controller(out_M1, out_M2, in_A, in_B, PPR){};   
    protected:
        void goto_pulse(int tar_pulse, float speed = 1);
};
    
class DC_Motor_PID: public DC_Motor_Controller 
{
    private:
        PID* pid;
    protected:
        void goto_pulse(int tar_pulse, float placeholder = 0);
    public:
        DC_Motor_PID(PinName out_M1, PinName out_M2, PinName in_A, PinName in_B, int PPR):DC_Motor_Controller(out_M1, out_M2, in_A, in_B, PPR){};  
        void set_pid(double Kp, double Ki, double Kd, double min);
};


#endif