#include "mbed.h"

// Código para testar os sensores de linha,lendo através do tempo de decaimento do sensor e utilizando o multiplexador
#define threshold 10600 // parametro que diferencia a leitura do branco pro preto
Serial bt (USBTX,USBRX);

PwmOut pwm(p25);
DigitalOut dir (p26);
PwmOut pwm1(p24);
DigitalOut dir1 (p23);

DigitalOut multiplexador1(p5); // portas do multiplexador que selecionam o sensor de linha
DigitalOut multiplexador2(p6);
DigitalOut multiplexador3(p8); // PRECISA AJUSTAR OS PINOS
DigitalOut multiplexador4(p7);
//DigitalOut multiplexador5(p9);// Enable do multiplexador
DigitalInOut multiplexadorInOut(p12); // In/Out do multiplexador 

int tabelaVerdade1[16] = {0,1,0,1,0,1,0,1,0,1,0,1,0,1,0,1}; // Arrays para selecionar o sensor de linha na função sensorCheck
int tabelaVerdade2[16] = {0,0,1,1,0,0,1,1,0,0,1,1,0,0,1,1};
int tabelaVerdade3[16] = {0,0,0,0,1,1,1,1,0,0,0,0,1,1,1,1};
int tabelaVerdade4[16] = {0,0,0,0,0,0,0,0,1,1,1,1,1,1,1,1};

Timer tempoDoSensor; // timer para leitura do sensor de linha

void Setup_Sensores (void){ //Define o modo de cada sensor
  
    
    multiplexadorInOut.mode(PullNone);
    multiplexadorInOut.input();
    bt.printf("Status do Sensor iniciando: %d ", multiplexadorInOut.read());
    multiplexadorInOut.output();
    multiplexadorInOut = 0;
    wait_ms(10);
    multiplexadorInOut.input();
    bt.printf("Status do SensorLOW: %d ", multiplexadorInOut.read());
    multiplexadorInOut.output();
    multiplexadorInOut = 1;
    wait_ms(10);
    multiplexadorInOut.input();
    bt.printf("Status do SensorHIGH: %d ", multiplexadorInOut.read());
    multiplexadorInOut.output();
    multiplexadorInOut = 0;
    wait_ms(10);
    multiplexadorInOut.input();
    bt.printf("Status do SensorLOW: %d ", multiplexadorInOut.read());
}



bool sensorCheck(int sensor){// int sensor é qual sensor se deseja ler,entre 0 a 15
    // função para ler os motores,retorna true se for branco e false se for preto
   
    multiplexador1 = tabelaVerdade1[sensor]; // selecionando o sensor
    multiplexador2 = tabelaVerdade2[sensor];
    multiplexador3 = tabelaVerdade3[sensor];
    multiplexador4 = tabelaVerdade4[sensor];
    //bt.printf("Status do Sensor entrando no check: %d ", multiplexadorInOut.read());
    multiplexadorInOut.output(); // colocando o InOut como Out
    multiplexadorInOut = 1; // levando ele a high por pelo menos 10 microssegundos
    
    tempoDoSensor.start(); // iniciando o contador
    
    wait_us(10); // tempo para o output ir para high

    multiplexadorInOut.input(); // colocando o InOut como In
    //bt.printf("Status do Sensor supostamente em HIGH: %d ", multiplexadorInOut.read());
    
    while(multiplexadorInOut == 1){// enrolando enquanto o sensor esta lendo
    //bt.printf("To no loop ->");
    //bt.printf("Status do Sensor: %d ", multiplexadorInOut.read());
        
        if (tempoDoSensor.read_us() >= threshold){// termina o while se o tempo for maior que o threshold,agilizando o processo de leitura      
            tempoDoSensor.stop();
            //bt.printf("To no if ->");
            float tempoDeLeitura = tempoDoSensor.read_us();
            bt.printf ("Tempo de leitura :%f \n\r ",tempoDeLeitura); // debug
            tempoDoSensor.reset();
            multiplexadorInOut.output();
            multiplexadorInOut = 0;
            return false; // retorna quando for preto
            }
        
    }
    tempoDoSensor.stop();
    float tempoDeLeitura = tempoDoSensor.read_us();
    bt.printf ("Tempo de leitura :%f \n\r ",tempoDeLeitura); // debug
    tempoDoSensor.reset();
    multiplexadorInOut.output();
    multiplexadorInOut = 0;
    return true;// retorna quando for branco
    }
void Final_Stop(){ dir = 0; dir1 = 0; pwm.write(0); pwm1.write(0);  } //Função de parada do LF depois do percurso

int main() {
    Setup_Sensores();
    while(1){
        Final_Stop();
        //bt.printf("Iniciando a leitura de sensores: ");
        bool tempoSensor0 = sensorCheck(0); // le e printa sensor 0
        bt.printf("Sensor 0:%d--",tempoSensor0);
        bool tempoSensor1 = sensorCheck(1); // le e printa sensor 1
        bt.printf("Sensor 1:%d--",tempoSensor1);
        bool tempoSensor2 = sensorCheck(2); // le e printa sensor 2   //1 É BRACO   0 É PRETO
        bt.printf("Sensor 2:%d--",tempoSensor2);
        bool tempoSensor3 = sensorCheck(3); // le e printa sensor 3
        bt.printf("Sensor 3:%d--",tempoSensor3);
        bool tempoSensor4 = sensorCheck(4); // le e printa sensor 4
        bt.printf("Sensor 4:%d--",tempoSensor4);
        bool tempoSensor5 = sensorCheck(5); // le e printa sensor 5
        bt.printf("Sensor 5:%d--",tempoSensor5);
        bool tempoSensor6 = sensorCheck(6); // le e printa sensor 6
        bt.printf("Sensor 6:%d--",tempoSensor6);
        bool tempoSensor7 = sensorCheck(7); // le e printa sensor 7
        bt.printf("Sensor 7:%d\n\r",tempoSensor7);
        
        }
    
}
